/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.RemoteAssistancePartner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerCollectionPage;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerCollectionRequest;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionPage;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionResponse;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerRequestBuilder;
import java.util.List;

public class RemoteAssistancePartnerCollectionRequest
extends BaseCollectionRequest<RemoteAssistancePartnerCollectionResponse, IRemoteAssistancePartnerCollectionPage>
implements IRemoteAssistancePartnerCollectionRequest {
    public RemoteAssistancePartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RemoteAssistancePartnerCollectionResponse.class, IRemoteAssistancePartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRemoteAssistancePartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RemoteAssistancePartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRemoteAssistancePartnerCollectionPage get() throws ClientException {
        RemoteAssistancePartnerCollectionResponse response = (RemoteAssistancePartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RemoteAssistancePartner newRemoteAssistancePartner, ICallback<RemoteAssistancePartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RemoteAssistancePartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRemoteAssistancePartner, callback);
    }

    @Override
    public RemoteAssistancePartner post(RemoteAssistancePartner newRemoteAssistancePartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RemoteAssistancePartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRemoteAssistancePartner);
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IRemoteAssistancePartnerCollectionPage buildFromResponse(RemoteAssistancePartnerCollectionResponse response) {
        RemoteAssistancePartnerCollectionRequestBuilder builder = response.nextLink != null ? new RemoteAssistancePartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RemoteAssistancePartnerCollectionPage page = new RemoteAssistancePartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

