/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Event;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EventCollectionPage;
import com.microsoft.graph.requests.extensions.EventCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EventCollectionResponse;
import com.microsoft.graph.requests.extensions.EventRequestBuilder;
import com.microsoft.graph.requests.extensions.IEventCollectionPage;
import com.microsoft.graph.requests.extensions.IEventCollectionRequest;
import java.util.List;

public class EventCollectionRequest
extends BaseCollectionRequest<EventCollectionResponse, IEventCollectionPage>
implements IEventCollectionRequest {
    public EventCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EventCollectionResponse.class, IEventCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEventCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EventCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEventCollectionPage get() throws ClientException {
        EventCollectionResponse response = (EventCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Event newEvent, ICallback<Event> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEvent, callback);
    }

    @Override
    public Event post(Event newEvent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEvent);
    }

    @Override
    public IEventCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEventCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEventCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IEventCollectionPage buildFromResponse(EventCollectionResponse response) {
        EventCollectionRequestBuilder builder = response.nextLink != null ? new EventCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EventCollectionPage page = new EventCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

