/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.GsonFactory;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSerializer
implements ISerializer {
    private final Gson gson;
    private final ILogger logger;

    public DefaultSerializer(ILogger logger) {
        this.logger = logger;
        this.gson = GsonFactory.getGsonInstance(logger);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz) {
        return this.deserializeObject(inputString, clazz, null);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz, Map<String, List<String>> responseHeaders) {
        Object jsonObject = this.gson.fromJson(inputString, clazz);
        if (jsonObject instanceof IJsonBackedObject) {
            this.logger.logDebug("Deserializing type " + clazz.getSimpleName());
            JsonObject rawObject = (JsonObject)this.gson.fromJson(inputString, JsonObject.class);
            Class<?> derivedClass = this.getDerivedClass(rawObject, clazz);
            Object jo = derivedClass != null ? this.gson.fromJson(inputString, derivedClass) : jsonObject;
            IJsonBackedObject jsonBackedObject = (IJsonBackedObject)jo;
            jsonBackedObject.setRawObject(this, rawObject);
            if (responseHeaders != null) {
                JsonElement convertedHeaders = this.gson.toJsonTree(responseHeaders);
                jsonBackedObject.additionalDataManager().put("graphResponseHeaders", convertedHeaders);
            }
            jsonBackedObject.additionalDataManager().setAdditionalData(rawObject);
            this.setChildAdditionalData(jsonBackedObject, rawObject);
            return (T)jo;
        }
        this.logger.logDebug("Deserializing a non-IJsonBackedObject type " + clazz.getSimpleName());
        return (T)jsonObject;
    }

    private void setChildAdditionalData(IJsonBackedObject serializedObject, JsonObject rawJson) {
        for (Field field : serializedObject.getClass().getFields()) {
            try {
                Object fieldObject = field.get(serializedObject);
                if (fieldObject instanceof HashMap) {
                    HashMap serializableChildren = (HashMap)fieldObject;
                    for (Map.Entry pair : serializableChildren.entrySet()) {
                        Object child = pair.getValue();
                        if (!(child instanceof IJsonBackedObject)) continue;
                        AdditionalDataManager childAdditionalDataManager = ((IJsonBackedObject)child).additionalDataManager();
                        if (rawJson == null || field == null || rawJson.get(field.getName()) == null || !rawJson.get(field.getName()).isJsonObject() || !rawJson.get(field.getName()).getAsJsonObject().get((String)pair.getKey()).isJsonObject()) continue;
                        childAdditionalDataManager.setAdditionalData(rawJson.get(field.getName()).getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                        this.setChildAdditionalData((IJsonBackedObject)child, rawJson.get(field.getName()).getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                    }
                    continue;
                }
                if (fieldObject == null || !(fieldObject instanceof IJsonBackedObject)) continue;
                IJsonBackedObject serializedChild = (IJsonBackedObject)fieldObject;
                AdditionalDataManager childAdditionalDataManager = serializedChild.additionalDataManager();
                if (rawJson == null || field == null || rawJson.get(field.getName()) == null || !rawJson.get(field.getName()).isJsonObject()) continue;
                childAdditionalDataManager.setAdditionalData(rawJson.get(field.getName()).getAsJsonObject());
                this.setChildAdditionalData((IJsonBackedObject)fieldObject, rawJson.get(field.getName()).getAsJsonObject());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.logError("Unable to access child fields of " + serializedObject.getClass().getSimpleName(), e);
            }
        }
    }

    @Override
    public <T> String serializeObject(T serializableObject) {
        this.logger.logDebug("Serializing type " + serializableObject.getClass().getSimpleName());
        JsonElement outJsonTree = this.gson.toJsonTree(serializableObject);
        if (serializableObject instanceof IJsonBackedObject) {
            IJsonBackedObject serializableJsonObject = (IJsonBackedObject)serializableObject;
            AdditionalDataManager additionalData = serializableJsonObject.additionalDataManager();
            if (outJsonTree.isJsonObject()) {
                JsonObject outJson = outJsonTree.getAsJsonObject();
                this.addAdditionalDataToJson(additionalData, outJson);
                outJson = this.getChildAdditionalData(serializableJsonObject, outJson);
                outJsonTree = outJson;
            }
        }
        return outJsonTree.toString();
    }

    private JsonObject getChildAdditionalData(IJsonBackedObject serializableObject, JsonObject outJson) {
        for (Field field : serializableObject.getClass().getFields()) {
            try {
                Object fieldObject = field.get(serializableObject);
                if (fieldObject instanceof HashMap) {
                    HashMap serializableChildren = (HashMap)fieldObject;
                    for (Map.Entry pair : serializableChildren.entrySet()) {
                        Object child = pair.getValue();
                        if (!(child instanceof IJsonBackedObject)) continue;
                        AdditionalDataManager childAdditionalData = ((IJsonBackedObject)child).additionalDataManager();
                        this.addAdditionalDataToJson(childAdditionalData, outJson.getAsJsonObject(field.getName()).getAsJsonObject().get(((String)pair.getKey()).toString()).getAsJsonObject());
                        outJson = this.getChildAdditionalData((IJsonBackedObject)child, outJson);
                    }
                    continue;
                }
                if (fieldObject == null || !(fieldObject instanceof IJsonBackedObject)) continue;
                IJsonBackedObject serializableChild = (IJsonBackedObject)fieldObject;
                AdditionalDataManager childAdditionalData = serializableChild.additionalDataManager();
                if (outJson != null && field != null && outJson.get(field.getName()) != null && outJson.get(field.getName()).isJsonObject()) {
                    this.addAdditionalDataToJson(childAdditionalData, outJson.get(field.getName()).getAsJsonObject());
                }
                outJson = this.getChildAdditionalData(serializableChild, outJson);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.logError("Unable to access child fields of " + serializableObject.getClass().getSimpleName(), e);
            }
        }
        return outJson;
    }

    private void addAdditionalDataToJson(AdditionalDataManager additionalDataManager, JsonObject jsonNode) {
        for (Map.Entry<String, JsonElement> entry : additionalDataManager.entrySet()) {
            if (this.fieldIsOdataTransient(entry)) continue;
            jsonNode.add(entry.getKey(), entry.getValue());
        }
    }

    private boolean fieldIsOdataTransient(Map.Entry<String, JsonElement> entry) {
        return entry.getKey().startsWith("@") && entry.getKey() != "@odata.type";
    }

    private Class<?> getDerivedClass(JsonObject jsonObject, Class<?> parentClass) {
        if (jsonObject.get("@odata.type") != null) {
            String odataType = jsonObject.get("@odata.type").getAsString();
            String derivedType = odataType.substring(odataType.lastIndexOf(46) + 1);
            derivedType = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, derivedType);
            derivedType = "com.microsoft.graph.models.extensions." + derivedType;
            try {
                Class<?> derivedClass = Class.forName(derivedType);
                if (parentClass.isAssignableFrom(derivedClass)) {
                    return derivedClass;
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.logger.logDebug("Unable to find a corresponding class for derived type " + derivedType + ". Falling back to parent class.");
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    public ILogger getLogger() {
        return this.logger;
    }
}

