/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdditionalDataManager
extends HashMap<String, JsonElement> {
    private static final long serialVersionUID = 8641634955796941429L;
    private final transient IJsonBackedObject jsonBackedObject;

    public AdditionalDataManager(IJsonBackedObject jsonBackedObject) {
        this.jsonBackedObject = jsonBackedObject;
    }

    final void setAdditionalData(JsonObject json) {
        Set<String> objectFields = this.getFields();
        Set<String> jsonKeys = this.getJsonKeys(json);
        HashSet<String> additionalDataKeys = new HashSet<String>(jsonKeys);
        additionalDataKeys.removeAll(objectFields);
        for (String jsonKey : additionalDataKeys) {
            this.put(jsonKey, json.get(jsonKey));
        }
    }

    private Set<String> getJsonKeys(JsonObject json) {
        HashSet<String> keys = new HashSet<String>();
        Set entries = json.entrySet();
        for (Map.Entry entry : entries) {
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    private Set<String> getFields() {
        Field[] fields = this.jsonBackedObject.getClass().getFields();
        HashSet<String> serializingFields = new HashSet<String>();
        for (Field field : fields) {
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (null == serializedName || null == field.getAnnotation(Expose.class)) continue;
            serializingFields.add(serializedName.value());
        }
        return serializingFields;
    }
}

