/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAppCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsAppCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAppCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAppCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsAppRequestBuilder;
import java.util.List;

public class TeamsAppCollectionRequest
extends BaseCollectionRequest<TeamsAppCollectionResponse, ITeamsAppCollectionPage>
implements ITeamsAppCollectionRequest {
    public TeamsAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsAppCollectionResponse.class, ITeamsAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAppCollectionPage get() throws ClientException {
        TeamsAppCollectionResponse response = (TeamsAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsApp newTeamsApp, ICallback<TeamsApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsApp, callback);
    }

    @Override
    public TeamsApp post(TeamsApp newTeamsApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsApp);
    }

    @Override
    public ITeamsAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITeamsAppCollectionPage buildFromResponse(TeamsAppCollectionResponse response) {
        TeamsAppCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAppCollectionPage page = new TeamsAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

