/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesRequestBuilder;
import java.util.List;

public class ManagedDeviceCollectionWithReferencesRequest
extends BaseCollectionRequest<ManagedDeviceCollectionResponse, IManagedDeviceCollectionPage>
implements IManagedDeviceCollectionWithReferencesRequest {
    public ManagedDeviceCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceCollectionResponse.class, IManagedDeviceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedDeviceCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedDeviceCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedDeviceCollectionWithReferencesPage get() throws ClientException {
        ManagedDeviceCollectionResponse response = (ManagedDeviceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IManagedDeviceCollectionWithReferencesPage buildFromResponse(ManagedDeviceCollectionResponse response) {
        ManagedDeviceCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ManagedDeviceCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedDeviceCollectionWithReferencesPage page = new ManagedDeviceCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

