/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.WorkbookChartAreaFormat;
import com.microsoft.graph.models.extensions.WorkbookChartAxes;
import com.microsoft.graph.models.extensions.WorkbookChartDataLabels;
import com.microsoft.graph.models.extensions.WorkbookChartLegend;
import com.microsoft.graph.models.extensions.WorkbookChartSeries;
import com.microsoft.graph.models.extensions.WorkbookChartTitle;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class WorkbookChart
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="height")
    @Expose
    public Double height;
    @SerializedName(value="left")
    @Expose
    public Double left;
    @SerializedName(value="name")
    @Expose
    public String name;
    @SerializedName(value="top")
    @Expose
    public Double top;
    @SerializedName(value="width")
    @Expose
    public Double width;
    @SerializedName(value="axes")
    @Expose
    public WorkbookChartAxes axes;
    @SerializedName(value="dataLabels")
    @Expose
    public WorkbookChartDataLabels dataLabels;
    @SerializedName(value="format")
    @Expose
    public WorkbookChartAreaFormat format;
    @SerializedName(value="legend")
    @Expose
    public WorkbookChartLegend legend;
    public WorkbookChartSeriesCollectionPage series;
    @SerializedName(value="title")
    @Expose
    public WorkbookChartTitle title;
    @SerializedName(value="worksheet")
    @Expose
    public WorkbookWorksheet worksheet;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("series")) {
            WorkbookChartSeriesCollectionResponse response = new WorkbookChartSeriesCollectionResponse();
            if (json.has("series@odata.nextLink")) {
                response.nextLink = json.get("series@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("series").toString(), JsonObject[].class);
            WorkbookChartSeries[] array = new WorkbookChartSeries[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), WorkbookChartSeries.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.series = new WorkbookChartSeriesCollectionPage(response, null);
        }
    }
}

