/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.AuthenticationHandler;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import com.microsoft.graph.httpcore.RedirectHandler;
import com.microsoft.graph.httpcore.RetryHandler;
import com.microsoft.graph.httpcore.TelemetryHandler;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpClients {
    private HttpClients() {
    }

    public static OkHttpClient.Builder custom() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new TelemetryHandler());
    }

    public static OkHttpClient createDefault(ICoreAuthenticationProvider auth) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationHandler(auth)).followRedirects(false).addInterceptor((Interceptor)new RetryHandler()).addInterceptor((Interceptor)new RedirectHandler()).addInterceptor((Interceptor)new TelemetryHandler()).build();
    }

    public static OkHttpClient createFromInterceptors(Interceptor[] interceptors) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        builder.addInterceptor((Interceptor)new TelemetryHandler());
        return builder.build();
    }
}

