/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.meilisearch.sdk.model.Key;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class GsonKeyTypeAdapter
extends TypeAdapter<Key> {
    private static final String KEY_NAME = "name";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_UID = "uid";
    private static final String KEY_KEY = "key";
    private static final String KEY_ACTIONS = "actions";
    private static final String KEY_INDEXES = "indexes";
    private static final String KEY_EXPIRES_AT = "expiresAt";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonWriter writer, Key key) throws IOException {
        boolean serializeNulls = writer.getSerializeNulls();
        writer.setSerializeNulls(true);
        try {
            this.writeStartObject(writer);
            this.writeString(writer, KEY_NAME, key.getName());
            this.writeString(writer, KEY_DESCRIPTION, key.getDescription());
            this.writeString(writer, KEY_UID, key.getUid());
            this.writeString(writer, KEY_KEY, key.getKey());
            this.writeStringArray(writer, KEY_ACTIONS, key.getActions());
            this.writeStringArray(writer, KEY_INDEXES, key.getIndexes());
            if (key.getExpiresAt() != null) {
                this.writeDate(writer, KEY_EXPIRES_AT, key.getExpiresAt());
            } else {
                this.writeNull(writer, KEY_EXPIRES_AT);
            }
            this.writeDate(writer, KEY_CREATED_AT, key.getCreatedAt());
            this.writeDate(writer, KEY_UPDATED_AT, key.getUpdatedAt());
            this.writeEndObject(writer);
        }
        finally {
            writer.setSerializeNulls(serializeNulls);
        }
    }

    public Key read(JsonReader reader) throws IOException {
        return this.nullOrElse(reader, r -> {
            Key key = new Key();
            this.readStartObject(r);
            block22: while (r.peek() != JsonToken.END_OBJECT) {
                switch (r.nextName()) {
                    case "name": {
                        key.setName(this.readString(r));
                        continue block22;
                    }
                    case "description": {
                        key.setDescription(this.readString(r));
                        continue block22;
                    }
                    case "uid": {
                        key.setUid(this.readString(r));
                        continue block22;
                    }
                    case "key": {
                        key.setKey(this.readString(r));
                        continue block22;
                    }
                    case "actions": {
                        key.setActions(this.readStringArray(r));
                        continue block22;
                    }
                    case "indexes": {
                        key.setIndexes(this.readStringArray(r));
                        continue block22;
                    }
                    case "expiresAt": {
                        key.setExpiresAt(this.readDate(r));
                        continue block22;
                    }
                    case "createdAt": {
                        key.setCreatedAt(this.readDate(r));
                        continue block22;
                    }
                    case "updatedAt": {
                        key.setUpdatedAt(this.readDate(r));
                        continue block22;
                    }
                }
                this.readAndDiscard(r);
            }
            this.readEndObject(r);
            return key;
        });
    }

    private void writeStartObject(JsonWriter writer) throws IOException {
        writer.beginObject();
    }

    private void writeEndObject(JsonWriter writer) throws IOException {
        writer.endObject();
    }

    private void writeNull(JsonWriter writer, String key) throws IOException {
        writer.name(key).nullValue();
    }

    private void writeString(JsonWriter writer, String key, String value) throws IOException {
        if (value == null) {
            return;
        }
        writer.name(key).value(value);
    }

    private void writeStringArray(JsonWriter writer, String key, String[] value) throws IOException {
        if (value == null) {
            return;
        }
        writer.name(key).beginArray();
        for (String item : value) {
            writer.value(item);
        }
        writer.endArray();
    }

    private void writeDate(JsonWriter writer, String key, Date value) throws IOException {
        if (value == null) {
            return;
        }
        writer.name(key).value(DATE_FORMAT.get().format(value));
    }

    private void readStartObject(JsonReader reader) throws IOException {
        reader.beginObject();
    }

    private void readEndObject(JsonReader reader) throws IOException {
        reader.endObject();
    }

    private String readString(JsonReader reader) throws IOException {
        return this.nullOrElse(reader, JsonReader::nextString);
    }

    private String[] readStringArray(JsonReader reader) throws IOException {
        return this.nullOrElse(reader, r -> {
            ArrayList<String> values = new ArrayList<String>();
            r.beginArray();
            while (r.peek() != JsonToken.END_ARRAY) {
                values.add(r.nextString());
            }
            r.endArray();
            return values.toArray(new String[0]);
        });
    }

    private Date readDate(JsonReader reader) throws IOException {
        return this.nullOrElse(reader, r -> this.parseDate(r.nextString()));
    }

    private void readAndDiscard(JsonReader reader) throws IOException {
        reader.skipValue();
    }

    private Date parseDate(String value) {
        return Date.from(Instant.parse(value));
    }

    private <T> T nullOrElse(JsonReader reader, ReadValueFunction<T> fn) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return fn.apply(reader);
    }

    private static interface ReadValueFunction<T> {
        public T apply(JsonReader var1) throws IOException;
    }
}

