/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.model.IndexStats;
import com.meilisearch.sdk.model.Stats;

public class InstanceHandler {
    private final HttpClient httpClient;

    protected InstanceHandler(Config config) {
        this.httpClient = config.httpClient;
    }

    String health() throws MeilisearchException {
        return this.httpClient.get("/health", String.class, new Class[0]);
    }

    boolean isHealthy() throws MeilisearchException {
        try {
            this.health();
            return true;
        }
        catch (MeilisearchException e) {
            return false;
        }
    }

    Stats getStats() throws MeilisearchException {
        return this.httpClient.get("/stats", Stats.class, new Class[0]);
    }

    IndexStats getIndexStats(String uid) throws MeilisearchException {
        String requestQuery = "/indexes/" + uid + "/stats";
        return this.httpClient.get(requestQuery, IndexStats.class, new Class[0]);
    }

    String getVersion() throws MeilisearchException {
        return this.httpClient.get("/version", String.class, new Class[0]);
    }
}

