/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.Index;
import com.meilisearch.sdk.IndexesHandler;
import com.meilisearch.sdk.InstanceHandler;
import com.meilisearch.sdk.KeysHandler;
import com.meilisearch.sdk.MultiSearchFederation;
import com.meilisearch.sdk.MultiSearchRequest;
import com.meilisearch.sdk.TasksHandler;
import com.meilisearch.sdk.TenantTokenOptions;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.json.JsonHandler;
import com.meilisearch.sdk.model.CancelTasksQuery;
import com.meilisearch.sdk.model.CursorResults;
import com.meilisearch.sdk.model.DeleteTasksQuery;
import com.meilisearch.sdk.model.IndexesQuery;
import com.meilisearch.sdk.model.Key;
import com.meilisearch.sdk.model.KeyUpdate;
import com.meilisearch.sdk.model.KeysQuery;
import com.meilisearch.sdk.model.MultiSearchResult;
import com.meilisearch.sdk.model.Results;
import com.meilisearch.sdk.model.Stats;
import com.meilisearch.sdk.model.SwapIndexesParams;
import com.meilisearch.sdk.model.Task;
import com.meilisearch.sdk.model.TaskInfo;
import com.meilisearch.sdk.model.TasksQuery;
import com.meilisearch.sdk.model.TasksResults;
import com.meilisearch.sdk.model.batch.req.BatchesQuery;
import com.meilisearch.sdk.model.batch.res.Batch;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class Client {
    private Config config;
    private IndexesHandler indexesHandler;
    private InstanceHandler instanceHandler;
    private TasksHandler tasksHandler;
    private KeysHandler keysHandler;
    private JsonHandler jsonHandler;

    public Client(Config config) {
        this.config = config;
        this.indexesHandler = new IndexesHandler(config);
        this.instanceHandler = new InstanceHandler(config);
        this.tasksHandler = new TasksHandler(config);
        this.keysHandler = new KeysHandler(config);
        this.jsonHandler = config.jsonHandler;
    }

    public TaskInfo createIndex(String uid) throws MeilisearchException {
        return this.createIndex(uid, null);
    }

    public TaskInfo createIndex(String uid, String primaryKey) throws MeilisearchException {
        return this.indexesHandler.createIndex(uid, primaryKey);
    }

    public Results<Index> getIndexes() throws MeilisearchException {
        Results<Index> indexes = this.indexesHandler.getIndexes();
        for (Index index : indexes.getResults()) {
            index.setConfig(this.config);
        }
        return indexes;
    }

    public Results<Index> getIndexes(IndexesQuery params) throws MeilisearchException {
        Results<Index> indexes = this.indexesHandler.getIndexes(params);
        for (Index index : indexes.getResults()) {
            index.setConfig(this.config);
        }
        return indexes;
    }

    public String getRawIndexes() throws MeilisearchException {
        return this.indexesHandler.getRawIndexes();
    }

    public String getRawIndexes(IndexesQuery params) throws MeilisearchException {
        return this.indexesHandler.getRawIndexes(params);
    }

    public Index index(String uid) throws MeilisearchException {
        Index index = new Index();
        index.uid = uid;
        index.setConfig(this.config);
        return index;
    }

    public Index getIndex(String uid) throws MeilisearchException {
        Index index = this.indexesHandler.getIndex(uid);
        index.setConfig(this.config);
        return index;
    }

    public TaskInfo updateIndex(String uid, String primaryKey) throws MeilisearchException {
        return this.indexesHandler.updatePrimaryKey(uid, primaryKey);
    }

    public TaskInfo deleteIndex(String uid) throws MeilisearchException {
        return this.indexesHandler.deleteIndex(uid);
    }

    public TaskInfo swapIndexes(SwapIndexesParams[] param) throws MeilisearchException {
        return this.config.httpClient.post("/swap-indexes", param, TaskInfo.class, new Class[0]);
    }

    public TaskInfo createDump() throws MeilisearchException {
        return this.config.httpClient.post("/dumps", "", TaskInfo.class, new Class[0]);
    }

    public TaskInfo createSnapshot() throws MeilisearchException {
        return this.config.httpClient.post("/snapshots", "", TaskInfo.class, new Class[0]);
    }

    public String health() throws MeilisearchException {
        return this.instanceHandler.health();
    }

    public Boolean isHealthy() throws MeilisearchException {
        return this.instanceHandler.isHealthy();
    }

    public Stats getStats() throws MeilisearchException {
        return this.instanceHandler.getStats();
    }

    public String getVersion() throws MeilisearchException {
        return this.instanceHandler.getVersion();
    }

    public Task getTask(int uid) throws MeilisearchException {
        return this.tasksHandler.getTask(uid);
    }

    public TasksResults getTasks() throws MeilisearchException {
        return this.tasksHandler.getTasks();
    }

    public TasksResults getTasks(TasksQuery param) throws MeilisearchException {
        return this.tasksHandler.getTasks(param);
    }

    public TaskInfo cancelTasks(CancelTasksQuery param) throws MeilisearchException {
        return this.tasksHandler.cancelTasks(param);
    }

    public TaskInfo deleteTasks(DeleteTasksQuery param) throws MeilisearchException {
        return this.tasksHandler.deleteTasks(param);
    }

    public void waitForTask(int uid) throws MeilisearchException {
        this.tasksHandler.waitForTask(uid);
    }

    public Batch getBatch(int uid) throws MeilisearchException {
        return this.tasksHandler.getBatch(uid);
    }

    public CursorResults<Batch> getAllBatches(BatchesQuery batchesQuery) throws MeilisearchException {
        return this.tasksHandler.getAllBatches(batchesQuery);
    }

    public Key getKey(String uid) throws MeilisearchException {
        return this.keysHandler.getKey(uid);
    }

    public Results<Key> getKeys() throws MeilisearchException {
        return this.keysHandler.getKeys();
    }

    public Results<Key> getKeys(KeysQuery params) throws MeilisearchException {
        return this.keysHandler.getKeys(params);
    }

    public Key createKey(Key options) throws MeilisearchException {
        return this.keysHandler.createKey(options);
    }

    public Key updateKey(String key, KeyUpdate options) throws MeilisearchException {
        return this.keysHandler.updateKey(key, options);
    }

    public void deleteKey(String key) throws MeilisearchException {
        this.keysHandler.deleteKey(key);
    }

    public MultiSearchResult multiSearch(MultiSearchRequest search, MultiSearchFederation federation) throws MeilisearchException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("queries", search.getQueries());
        payload.put("federation", federation);
        return this.config.httpClient.post("/multi-search", payload, MultiSearchResult.class, new Class[0]);
    }

    public Results<MultiSearchResult> multiSearch(MultiSearchRequest search) throws MeilisearchException {
        return this.config.httpClient.post("/multi-search", search, Results.class, MultiSearchResult.class);
    }

    public void experimentalFeatures(Map<String, Boolean> features) {
        this.config.httpClient.patch("/experimental-features", features, Void.class);
    }

    public String generateTenantToken(String apiKeyUid, Map<String, Object> searchRules) throws MeilisearchException {
        return this.generateTenantToken(apiKeyUid, searchRules, new TenantTokenOptions());
    }

    public String generateTenantToken(String apiKeyUid, Map<String, Object> searchRules, TenantTokenOptions options) throws MeilisearchException {
        Date now = new Date();
        String secret = options.getApiKey() == null || options.getApiKey() == "" ? this.config.apiKey : options.getApiKey();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (options.getExpiresAt() != null && now.after(options.getExpiresAt())) {
            throw new MeilisearchException("The date expiresAt should be in the future.");
        }
        if (secret == null || secret == "" || secret.length() <= 8) {
            throw new MeilisearchException("An api key is required in the client or should be passed as an argument and this key cannot be the master key.");
        }
        if (searchRules == null) {
            throw new MeilisearchException("The searchRules field is mandatory and should be defined.");
        }
        if (apiKeyUid == "" || apiKeyUid == null || !this.isValidUUID(apiKeyUid).booleanValue()) {
            throw new MeilisearchException("The uid used for the token generation must exist and comply to uuid4 format");
        }
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        String jwtToken = JWT.create().withClaim("searchRules", searchRules).withClaim("apiKeyUid", apiKeyUid).withExpiresAt(options.getExpiresAt()).sign(algorithm);
        return jwtToken;
    }

    private Boolean isValidUUID(String apiKeyUid) {
        try {
            UUID uUID = UUID.fromString(apiKeyUid);
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return true;
    }
}

