/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EmbedderDistribution {
    private Double mean;
    private Double sigma;

    public static EmbedderDistribution uniform() {
        return new EmbedderDistribution().setMean(0.5).setSigma(0.5);
    }

    public static EmbedderDistribution custom(double mean, double sigma) {
        if (mean < 0.0 || mean > 1.0) {
            throw new IllegalArgumentException("Mean must be between 0 and 1");
        }
        if (sigma < 0.0 || sigma > 1.0) {
            throw new IllegalArgumentException("Sigma must be between 0 and 1");
        }
        return new EmbedderDistribution().setMean(mean).setSigma(sigma);
    }

    @Generated
    public static EmbedderDistributionBuilder builder() {
        return new EmbedderDistributionBuilder();
    }

    @Generated
    EmbedderDistribution(Double mean, Double sigma) {
        this.mean = mean;
        this.sigma = sigma;
    }

    @Generated
    public EmbedderDistribution() {
    }

    @Generated
    public Double getMean() {
        return this.mean;
    }

    @Generated
    public Double getSigma() {
        return this.sigma;
    }

    @Generated
    public EmbedderDistribution setMean(Double mean) {
        this.mean = mean;
        return this;
    }

    @Generated
    public EmbedderDistribution setSigma(Double sigma) {
        this.sigma = sigma;
        return this;
    }

    @Generated
    public static class EmbedderDistributionBuilder {
        @Generated
        private Double mean;
        @Generated
        private Double sigma;

        @Generated
        EmbedderDistributionBuilder() {
        }

        @Generated
        public EmbedderDistributionBuilder mean(Double mean) {
            this.mean = mean;
            return this;
        }

        @Generated
        public EmbedderDistributionBuilder sigma(Double sigma) {
            this.sigma = sigma;
            return this;
        }

        @Generated
        public EmbedderDistribution build() {
            return new EmbedderDistribution(this.mean, this.sigma);
        }

        @Generated
        public String toString() {
            return "EmbedderDistribution.EmbedderDistributionBuilder(mean=" + this.mean + ", sigma=" + this.sigma + ")";
        }
    }
}

