/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk.http;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import lombok.Generated;

public class URLBuilder {
    private StringBuilder routes;
    private StringBuilder params;

    public URLBuilder() {
        this.routes = new StringBuilder();
        this.params = new StringBuilder();
    }

    public URLBuilder(String rootRoute) {
        this.routes = new StringBuilder(rootRoute);
        this.params = new StringBuilder();
    }

    public URLBuilder addSubroute(String route) {
        this.routes.append("/");
        this.routes.append(route);
        return this;
    }

    public URLBuilder addParameter(String parameter, String value) {
        if (value != "") {
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(value);
        }
        return this;
    }

    public URLBuilder addParameter(String parameter, int value) {
        if (value > -1) {
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(value);
        }
        return this;
    }

    public URLBuilder addParameter(String parameter, String[] value) {
        if (value != null && value.length > 0) {
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(this.formatArrayParameters(value));
        }
        return this;
    }

    public URLBuilder addParameter(String parameter, int[] value) {
        if (value != null && value.length > 0) {
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(this.formatArrayParameters(value));
        }
        return this;
    }

    public URLBuilder addParameter(String parameter, Date value) {
        if (value != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(formatter.format(value));
        }
        return this;
    }

    public URLBuilder addParameter(String parameter, Boolean value) {
        if (value != null) {
            this.addSeparator();
            this.params.append(parameter);
            this.params.append("=");
            this.params.append(value);
        }
        return this;
    }

    public URLBuilder addQuery(String query) {
        this.params.append(query);
        return this;
    }

    private URLBuilder addSeparator() {
        if (this.params.length() > 0) {
            this.params.append("&");
        } else {
            this.params.append("?");
        }
        return this;
    }

    private String formatArrayParameters(String[] fields) {
        return String.join((CharSequence)",", fields);
    }

    private String formatArrayParameters(int[] fields) {
        CharSequence[] arr = (String[])Arrays.stream(fields).mapToObj(String::valueOf).toArray(String[]::new);
        return String.join((CharSequence)",", arr);
    }

    public String getURL() {
        return this.routes.toString() + this.params.toString();
    }

    @Generated
    public StringBuilder getRoutes() {
        return this.routes;
    }

    @Generated
    public StringBuilder getParams() {
        return this.params;
    }
}

