/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.http.URLBuilder;
import com.meilisearch.sdk.model.Embedder;
import com.meilisearch.sdk.model.Faceting;
import com.meilisearch.sdk.model.LocalizedAttribute;
import com.meilisearch.sdk.model.Pagination;
import com.meilisearch.sdk.model.Settings;
import com.meilisearch.sdk.model.TaskInfo;
import com.meilisearch.sdk.model.TypoTolerance;
import java.util.Map;

public class SettingsHandler {
    private final HttpClient httpClient;

    protected SettingsHandler(Config config) {
        this.httpClient = config.httpClient;
    }

    Settings getSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).getURL(), Settings.class, new Class[0]);
    }

    TaskInfo updateSettings(String uid, Settings settings) throws MeilisearchException {
        return this.httpClient.patch(this.settingsPath(uid).getURL(), settings, TaskInfo.class);
    }

    TaskInfo resetSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).getURL(), TaskInfo.class);
    }

    String[] getRankingRulesSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("ranking-rules").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateRankingRulesSettings(String uid, String[] rankingRules) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("ranking-rules").getURL(), rankingRules == null ? this.httpClient.jsonHandler.encode(rankingRules) : rankingRules, TaskInfo.class);
    }

    TaskInfo resetRankingRulesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("ranking-rules").getURL(), TaskInfo.class);
    }

    Map<String, String[]> getSynonymsSettings(String uid) throws MeilisearchException {
        return this.httpClient.jsonHandler.decode(this.httpClient.get(this.settingsPath(uid).addSubroute("synonyms").getURL(), String.class, new Class[0]), Map.class, new Class[0]);
    }

    TaskInfo updateSynonymsSettings(String uid, Map<String, String[]> synonyms) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("synonyms").getURL(), synonyms == null ? this.httpClient.jsonHandler.encode(synonyms) : synonyms, TaskInfo.class);
    }

    TaskInfo resetSynonymsSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("synonyms").getURL(), TaskInfo.class);
    }

    String[] getStopWordsSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("stop-words").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateStopWordsSettings(String uid, String[] stopWords) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("stop-words").getURL(), stopWords == null ? this.httpClient.jsonHandler.encode(stopWords) : stopWords, TaskInfo.class);
    }

    TaskInfo resetStopWordsSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("stop-words").getURL(), TaskInfo.class);
    }

    String[] getSearchableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("searchable-attributes").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateSearchableAttributesSettings(String uid, String[] searchableAttributes) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("searchable-attributes").getURL(), searchableAttributes == null ? this.httpClient.jsonHandler.encode(searchableAttributes) : searchableAttributes, TaskInfo.class);
    }

    TaskInfo resetSearchableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("searchable-attributes").getURL(), TaskInfo.class);
    }

    String[] getDisplayedAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("displayed-attributes").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateDisplayedAttributesSettings(String uid, String[] displayAttributes) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("displayed-attributes").getURL(), displayAttributes == null ? this.httpClient.jsonHandler.encode(displayAttributes) : displayAttributes, TaskInfo.class);
    }

    TaskInfo resetDisplayedAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("displayed-attributes").getURL(), TaskInfo.class);
    }

    LocalizedAttribute[] getLocalizedAttributes(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("localized-attributes").getURL(), LocalizedAttribute[].class, new Class[0]);
    }

    TaskInfo updateLocalizedAttributesSettings(String uid, LocalizedAttribute[] localizedAttributes) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("localized-attributes").getURL(), localizedAttributes == null ? this.httpClient.jsonHandler.encode(localizedAttributes) : localizedAttributes, TaskInfo.class);
    }

    TaskInfo resetLocalizedAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("localized-attributes").getURL(), TaskInfo.class);
    }

    String[] getFilterableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("filterable-attributes").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateFilterableAttributesSettings(String uid, String[] filterableAttributes) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("filterable-attributes").getURL(), filterableAttributes == null ? this.httpClient.jsonHandler.encode(filterableAttributes) : filterableAttributes, TaskInfo.class);
    }

    TaskInfo resetFilterableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("filterable-attributes").getURL(), TaskInfo.class);
    }

    String[] getSortableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("sortable-attributes").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateSortableAttributesSettings(String uid, String[] sortableAttributes) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("sortable-attributes").getURL(), sortableAttributes == null ? this.httpClient.jsonHandler.encode(sortableAttributes) : sortableAttributes, TaskInfo.class);
    }

    TaskInfo resetSortableAttributesSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("sortable-attributes").getURL(), TaskInfo.class);
    }

    String getDistinctAttributeSettings(String uid) throws MeilisearchException {
        String response = this.httpClient.get(this.settingsPath(uid).addSubroute("distinct-attribute").getURL(), String.class, new Class[0]);
        return response.equals("null") ? null : response.substring(1, response.length() - 1);
    }

    TaskInfo updateDistinctAttributeSettings(String uid, String distinctAttribute) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("distinct-attribute").getURL(), distinctAttribute == null ? this.httpClient.jsonHandler.encode(distinctAttribute) : "\"" + distinctAttribute + "\"", TaskInfo.class);
    }

    TaskInfo resetDistinctAttributeSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("distinct-attribute").getURL(), TaskInfo.class);
    }

    TypoTolerance getTypoToleranceSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("typo-tolerance").getURL(), TypoTolerance.class, new Class[0]);
    }

    TaskInfo updateTypoToleranceSettings(String uid, TypoTolerance typoTolerance) throws MeilisearchException {
        return this.httpClient.patch(this.settingsPath(uid).addSubroute("typo-tolerance").getURL(), typoTolerance == null ? this.httpClient.jsonHandler.encode(typoTolerance) : typoTolerance, TaskInfo.class);
    }

    TaskInfo resetTypoToleranceSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("typo-tolerance").getURL(), TaskInfo.class);
    }

    Pagination getPaginationSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("pagination").getURL(), Pagination.class, new Class[0]);
    }

    TaskInfo updatePaginationSettings(String uid, Pagination pagination) throws MeilisearchException {
        return this.httpClient.patch(this.settingsPath(uid).addSubroute("pagination").getURL(), pagination == null ? this.httpClient.jsonHandler.encode(pagination) : pagination, TaskInfo.class);
    }

    TaskInfo resetPaginationSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("pagination").getURL(), TaskInfo.class);
    }

    Faceting getFacetingSettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("faceting").getURL(), Faceting.class, new Class[0]);
    }

    TaskInfo updateFacetingSettings(String uid, Faceting faceting) throws MeilisearchException {
        return this.httpClient.patch(this.settingsPath(uid).addSubroute("faceting").getURL(), faceting == null ? this.httpClient.jsonHandler.encode(faceting) : faceting, TaskInfo.class);
    }

    TaskInfo resetFacetingSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("faceting").getURL(), TaskInfo.class);
    }

    String[] getDictionarySettings(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("dictionary").getURL(), String[].class, new Class[0]);
    }

    TaskInfo updateDictionarySettings(String uid, String[] dictionary) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("dictionary").getURL(), dictionary == null ? this.httpClient.jsonHandler.encode(dictionary) : dictionary, TaskInfo.class);
    }

    TaskInfo resetDictionarySettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("dictionary").getURL(), TaskInfo.class);
    }

    String getProximityPrecisionSettings(String uid) throws MeilisearchException {
        String response = this.httpClient.get(this.settingsPath(uid).addSubroute("proximity-precision").getURL(), String.class, new Class[0]);
        return response.substring(1, response.length() - 1);
    }

    TaskInfo updateProximityPrecisionSettings(String uid, String proximityPrecision) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("proximity-precision").getURL(), proximityPrecision == null ? this.httpClient.jsonHandler.encode(proximityPrecision) : "\"" + proximityPrecision + "\"", TaskInfo.class);
    }

    TaskInfo resetProximityPrecisionSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("proximity-precision").getURL(), TaskInfo.class);
    }

    private URLBuilder settingsPath(String uid) {
        return new URLBuilder("/indexes").addSubroute(uid).addSubroute("/settings");
    }

    Integer getSearchCutoffMsSettings(String uid) throws MeilisearchException {
        String response = this.httpClient.get(this.settingsPath(uid).addSubroute("search-cutoff-ms").getURL(), String.class, new Class[0]);
        return response.equals("null") ? null : Integer.valueOf(response);
    }

    TaskInfo updateSearchCutoffMsSettings(String uid, Integer milliseconds) throws MeilisearchException {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("search-cutoff-ms").getURL(), milliseconds == null ? this.httpClient.jsonHandler.encode(milliseconds) : milliseconds, TaskInfo.class);
    }

    TaskInfo resetSearchCutoffMsSettings(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("search-cutoff-ms").getURL(), TaskInfo.class);
    }

    public String[] getSeparatorTokensSettings(String uid) {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("separator-tokens").getURL(), String[].class, new Class[0]);
    }

    public TaskInfo updateSeparatorTokensSettings(String uid, String[] separatorTokens) {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("separator-tokens").getURL(), separatorTokens == null ? this.httpClient.jsonHandler.encode(separatorTokens) : separatorTokens, TaskInfo.class);
    }

    public TaskInfo resetSeparatorTokensSettings(String uid) {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("separator-tokens").getURL(), TaskInfo.class);
    }

    public String[] getNonSeparatorTokensSettings(String uid) {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("non-separator-tokens").getURL(), String[].class, new Class[0]);
    }

    public TaskInfo updateNonSeparatorTokensSettings(String uid, String[] separatorTokens) {
        return this.httpClient.put(this.settingsPath(uid).addSubroute("non-separator-tokens").getURL(), separatorTokens == null ? this.httpClient.jsonHandler.encode(separatorTokens) : separatorTokens, TaskInfo.class);
    }

    public TaskInfo resetNonSeparatorTokensSettings(String uid) {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("non-separator-tokens").getURL(), TaskInfo.class);
    }

    Map<String, Embedder> getEmbedders(String uid) throws MeilisearchException {
        return this.httpClient.get(this.settingsPath(uid).addSubroute("embedders").getURL(), Map.class, String.class, Embedder.class);
    }

    TaskInfo updateEmbedders(String uid, Map<String, Embedder> embedders) throws MeilisearchException {
        return this.httpClient.patch(this.settingsPath(uid).addSubroute("embedders").getURL(), embedders == null ? null : this.httpClient.jsonHandler.encode(embedders), TaskInfo.class);
    }

    TaskInfo resetEmbedders(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.settingsPath(uid).addSubroute("embedders").getURL(), TaskInfo.class);
    }
}

