/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.FacetSearchRequest;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.model.FacetSearchResult;
import com.meilisearch.sdk.model.FacetSearchable;

public class FacetSearch {
    private final HttpClient httpClient;

    protected FacetSearch(Config config) {
        this.httpClient = config.httpClient;
    }

    String rawSearch(String uid, FacetSearchRequest fsr) throws MeilisearchException {
        String requestQuery = "/indexes/" + uid + "/facet-search";
        if (fsr.getFacetName() == null) {
            throw new MeilisearchException("Facet name is required for a facet search");
        }
        return this.httpClient.post(requestQuery, fsr.toString(), String.class, new Class[0]);
    }

    FacetSearchable facetSearch(String uid, FacetSearchRequest fsr) throws MeilisearchException {
        return this.httpClient.jsonHandler.decode(this.rawSearch(uid, fsr), FacetSearchResult.class, new Class[0]);
    }
}

