/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.SearchRequest;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.model.SearchResult;
import com.meilisearch.sdk.model.SearchResultPaginated;
import com.meilisearch.sdk.model.Searchable;

public class Search {
    private final HttpClient httpClient;

    protected Search(Config config) {
        this.httpClient = config.httpClient;
    }

    String rawSearch(String uid, String q) throws MeilisearchException {
        String requestQuery = "/indexes/" + uid + "/search";
        SearchRequest sr = SearchRequest.builder().q(q).build();
        return this.httpClient.post(requestQuery, sr, String.class, new Class[0]);
    }

    String rawSearch(String uid, SearchRequest sr) throws MeilisearchException {
        String requestQuery = "/indexes/" + uid + "/search";
        return this.httpClient.post(requestQuery, sr.toString(), String.class, new Class[0]);
    }

    SearchResult search(String uid, String q) throws MeilisearchException {
        return this.httpClient.jsonHandler.decode(this.rawSearch(uid, q), SearchResult.class, new Class[0]);
    }

    Searchable search(String uid, SearchRequest sr) throws MeilisearchException {
        if (sr != null && (sr.getPage() != null || sr.getHitsPerPage() != null)) {
            return this.httpClient.jsonHandler.decode(this.rawSearch(uid, sr), SearchResultPaginated.class, new Class[0]);
        }
        return this.httpClient.jsonHandler.decode(this.rawSearch(uid, sr), SearchResult.class, new Class[0]);
    }
}

