/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.exceptions.APIError;
import com.meilisearch.sdk.exceptions.MeilisearchApiException;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.http.CustomOkHttpClient;
import com.meilisearch.sdk.http.request.BasicRequest;
import com.meilisearch.sdk.http.request.HttpMethod;
import com.meilisearch.sdk.http.request.HttpRequest;
import com.meilisearch.sdk.http.response.BasicResponse;
import com.meilisearch.sdk.http.response.HttpResponse;
import com.meilisearch.sdk.json.GsonJsonHandler;
import com.meilisearch.sdk.json.JsonHandler;
import java.util.Collections;
import java.util.Map;

public class HttpClient {
    private final CustomOkHttpClient client;
    private final BasicRequest request;
    private final BasicResponse response;
    private final Map<String, String> headers;
    protected final JsonHandler jsonHandler;

    public HttpClient(Config config) {
        this.client = new CustomOkHttpClient(config);
        this.jsonHandler = config.jsonHandler;
        this.headers = config.headers;
        this.request = new BasicRequest(this.jsonHandler);
        this.response = new BasicResponse(this.jsonHandler);
    }

    public HttpClient(CustomOkHttpClient client, BasicRequest request) {
        this.client = client;
        this.request = request;
        this.headers = Collections.emptyMap();
        this.jsonHandler = new GsonJsonHandler();
        this.response = new BasicResponse(this.jsonHandler);
    }

    <T> T get(String api, Class<T> targetClass, Class<?> ... parameters) throws MeilisearchException {
        return this.get(api, "", targetClass, parameters);
    }

    <T> T get(String api, String param, Class<T> targetClass, Class<?> ... parameters) throws MeilisearchException {
        HttpRequest requestConfig = this.request.create(HttpMethod.GET, api + param, this.headers, null);
        HttpResponse httpRequest = this.client.get(requestConfig);
        HttpResponse<T> httpResponse = this.response.create(httpRequest, targetClass, parameters);
        if (httpResponse.getStatusCode() >= 400) {
            throw new MeilisearchApiException(this.jsonHandler.decode(httpRequest.getContent(), APIError.class, new Class[0]));
        }
        return httpResponse.getContent();
    }

    <S, T> T post(String api, S body, Class<T> targetClass, Class<?> ... parameters) throws MeilisearchException {
        HttpRequest requestConfig = this.request.create(HttpMethod.POST, api, this.headers, body);
        HttpResponse httpRequest = this.client.post(requestConfig);
        HttpResponse<T> httpResponse = this.response.create(httpRequest, targetClass, parameters);
        if (httpResponse.getStatusCode() >= 400) {
            throw new MeilisearchApiException(this.jsonHandler.decode(httpRequest.getContent(), APIError.class, new Class[0]));
        }
        return httpResponse.getContent();
    }

    <S, T> T put(String api, S body, Class<T> targetClass) throws MeilisearchException {
        HttpRequest requestConfig = this.request.create(HttpMethod.PUT, api, this.headers, body);
        HttpResponse httpRequest = this.client.put(requestConfig);
        HttpResponse<T> httpResponse = this.response.create(httpRequest, targetClass, new Class[0]);
        if (httpResponse.getStatusCode() >= 400) {
            throw new MeilisearchApiException(this.jsonHandler.decode(httpRequest.getContent(), APIError.class, new Class[0]));
        }
        return httpResponse.getContent();
    }

    <S, T> T patch(String api, S body, Class<T> targetClass) throws MeilisearchException {
        HttpRequest requestConfig = this.request.create(HttpMethod.PATCH, api, this.headers, body);
        HttpResponse httpResponse = this.client.patch(requestConfig);
        if (httpResponse.getStatusCode() >= 400) {
            throw new MeilisearchApiException(this.jsonHandler.decode(httpResponse.getContent(), APIError.class, new Class[0]));
        }
        return this.response.create(httpResponse, targetClass, new Class[0]).getContent();
    }

    <T> T delete(String api, Class<T> targetClass) throws MeilisearchException {
        HttpRequest requestConfig = this.request.create(HttpMethod.DELETE, api, this.headers, null);
        HttpResponse httpRequest = this.client.delete(requestConfig);
        HttpResponse<T> httpResponse = this.response.create(httpRequest, targetClass, new Class[0]);
        if (httpResponse.getStatusCode() >= 400) {
            throw new MeilisearchApiException(this.jsonHandler.decode(httpRequest.getContent(), APIError.class, new Class[0]));
        }
        return httpResponse.getContent();
    }
}

