/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.server;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpRequestDecoder;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseEncoder;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.utils.base64.Base64Utils;
import com.litongjava.tio.utils.digest.Sha1Utils;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.websocket.common.Opcode;
import com.litongjava.tio.websocket.common.WebSocketRequest;
import com.litongjava.tio.websocket.common.WebSocketResponse;
import com.litongjava.tio.websocket.common.WebSocketServerDecoder;
import com.litongjava.tio.websocket.common.WebSocketServerEncoder;
import com.litongjava.tio.websocket.common.WebSocketSessionContext;
import com.litongjava.tio.websocket.server.WebsocketServerConfig;
import com.litongjava.tio.websocket.server.handler.IWebSocketHandler;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(WebsocketServerAioHandler.class);
    private static final String NOT_FINAL_WEBSOCKET_PACKET_PARTS = "TIO_N_F_W_P_P";
    private static final String SEC_WEBSOCKET_KEY_SUFFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final byte[] SEC_WEBSOCKET_KEY_SUFFIX_BYTES = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes();
    private WebsocketServerConfig wsServerConfig;
    private IWebSocketHandler wsMsgHandler;

    public WebsocketServerAioHandler(WebsocketServerConfig wsServerConfig, IWebSocketHandler wsMsgHandler) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
    }

    public WebSocketRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
        if (!wsSessionContext.isHandshaked()) {
            HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (int)limit, (int)position, (int)readableLength, (ChannelContext)channelContext, (HttpConfig)this.wsServerConfig);
            if (request == null) {
                return null;
            }
            HttpResponse httpResponse = WebsocketServerAioHandler.upgradeWebSocketProtocol(request, channelContext);
            if (httpResponse == null) {
                throw new TioDecodeException("Failed to upgrade the HTTP protocol to the WebSocket protocol.");
            }
            wsSessionContext.setHandshakeRequest(request);
            wsSessionContext.setHandshakeResponse(httpResponse);
            WebSocketRequest wsRequestPacket = new WebSocketRequest();
            wsRequestPacket.setHandShake(true);
            return wsRequestPacket;
        }
        WebSocketRequest websocketPacket = WebSocketServerDecoder.decode((ByteBuffer)buffer, (ChannelContext)channelContext);
        if (websocketPacket != null) {
            if (!websocketPacket.isWsEof()) {
                ArrayList<WebSocketRequest> parts = (ArrayList<WebSocketRequest>)channelContext.getAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts == null) {
                    parts = new ArrayList<WebSocketRequest>();
                    channelContext.setAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS, parts);
                }
                parts.add(websocketPacket);
            } else {
                byte[] bodyBs;
                List parts = (List)channelContext.getAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts != null) {
                    channelContext.setAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS, null);
                    parts.add(websocketPacket);
                    WebSocketRequest first = (WebSocketRequest)parts.get(0);
                    websocketPacket.setWsOpcode(first.getWsOpcode());
                    int allBodyLength = 0;
                    for (WebSocketRequest wsRequest : parts) {
                        allBodyLength += wsRequest.getBody().length;
                    }
                    byte[] allBody = new byte[allBodyLength];
                    Integer index = 0;
                    for (WebSocketRequest wsRequest : parts) {
                        System.arraycopy(wsRequest.getBody(), 0, allBody, index, wsRequest.getBody().length);
                        index = index + wsRequest.getBody().length;
                    }
                    websocketPacket.setBody(allBody);
                }
                HttpRequest handshakeRequest = wsSessionContext.getHandshakeRequest();
                if (websocketPacket.getWsOpcode() != Opcode.BINARY && (bodyBs = websocketPacket.getBody()) != null) {
                    try {
                        String text = new String(bodyBs, handshakeRequest.getCharset());
                        websocketPacket.setWsBodyText(text);
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        return websocketPacket;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        WebSocketResponse wsResponse = (WebSocketResponse)packet;
        if (wsResponse.isHandShake()) {
            WebSocketSessionContext imSessionContext = (WebSocketSessionContext)channelContext.get();
            HttpResponse handshakeResponse = imSessionContext.getHandshakeResponse();
            return HttpResponseEncoder.encode((HttpResponse)handshakeResponse, (TioConfig)tioConfig, (ChannelContext)channelContext);
        }
        ByteBuffer byteBuffer = WebSocketServerEncoder.encode((WebSocketResponse)wsResponse, (TioConfig)tioConfig, (ChannelContext)channelContext);
        return byteBuffer;
    }

    public WebsocketServerConfig getHttpConfig() {
        return this.wsServerConfig;
    }

    private WebSocketResponse h(WebSocketRequest websocketPacket, byte[] bytes, Opcode opcode, ChannelContext channelContext) throws Exception {
        WebSocketResponse wsResponse = null;
        String charset = channelContext.getTioConfig().getCharset();
        if (opcode == Opcode.TEXT) {
            if (bytes == null || bytes.length == 0) {
                Tio.remove((ChannelContext)channelContext, (String)"Incorrect websocket packet, body is empty.");
                return null;
            }
            String text = new String(bytes, charset);
            Object retObj = this.wsMsgHandler.onText(websocketPacket, text, channelContext);
            String methodName = "onText";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.BINARY) {
            if (bytes == null || bytes.length == 0) {
                Tio.remove((ChannelContext)channelContext, (String)"Incorrect websocket packet, body is empty.");
                return null;
            }
            Object retObj = this.wsMsgHandler.onBytes(websocketPacket, bytes, channelContext);
            String methodName = "onBytes";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.PING || opcode == Opcode.PONG) {
            if (log.isDebugEnabled()) {
                log.debug("received" + opcode);
            }
            return null;
        }
        if (opcode == Opcode.CLOSE) {
            Object retObj = this.wsMsgHandler.onClose(websocketPacket, bytes, channelContext);
            String methodName = "onClose";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        Tio.remove((ChannelContext)channelContext, (String)"Incorrect websocket packet, incorrect Opcode");
        return null;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        WebSocketRequest wsRequest = (WebSocketRequest)packet;
        if (wsRequest.isHandShake()) {
            HttpResponse httpResponse;
            WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
            HttpRequest request = wsSessionContext.getHandshakeRequest();
            HttpResponse r = this.wsMsgHandler.handshake(request, httpResponse = wsSessionContext.getHandshakeResponse(), channelContext);
            if (r == null) {
                Tio.remove((ChannelContext)channelContext, (String)"The business layer does not agree to handshake.");
                return;
            }
            wsSessionContext.setHandshakeResponse(r);
            WebSocketResponse wsResponse = new WebSocketResponse();
            wsResponse.setHandShake(true);
            if (wsResponse.isBlockSend()) {
                Tio.bSend((ChannelContext)channelContext, (Packet)wsResponse);
            } else {
                Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
            }
            wsSessionContext.setHandshaked(true);
            this.wsMsgHandler.onAfterHandshaked(request, httpResponse, channelContext);
            return;
        }
        if (!wsRequest.isWsEof()) {
            return;
        }
        WebSocketResponse wsResponse = this.h(wsRequest, wsRequest.getBody(), wsRequest.getWsOpcode(), channelContext);
        if (wsResponse != null) {
            Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
        }
    }

    private WebSocketResponse processRetObj(Object obj, String methodName, ChannelContext channelContext) throws Exception {
        String charset = channelContext.getTioConfig().getCharset();
        WebSocketResponse wsResponse = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            wsResponse = WebSocketResponse.fromText((String)str, (String)charset);
            return wsResponse;
        }
        if (obj instanceof byte[]) {
            wsResponse = WebSocketResponse.fromBytes((byte[])((byte[])obj));
            return wsResponse;
        }
        if (obj instanceof WebSocketResponse) {
            return (WebSocketResponse)obj;
        }
        if (obj instanceof ByteBuffer) {
            byte[] bs = ((ByteBuffer)obj).array();
            wsResponse = WebSocketResponse.fromBytes((byte[])bs);
            return wsResponse;
        }
        log.error("{} {}.{}()\u65b9\u6cd5\uff0c\u53ea\u5141\u8bb8\u8fd4\u56debyte[]\u3001ByteBuffer\u3001WsResponse\u6216null\uff0c\u4f46\u662f\u7a0b\u5e8f\u8fd4\u56de\u4e86{}", new Object[]{channelContext, this.getClass().getName(), methodName, obj.getClass().getName()});
        return null;
    }

    public void setHttpConfig(WebsocketServerConfig httpConfig) {
        this.wsServerConfig = httpConfig;
    }

    public static HttpResponse upgradeWebSocketProtocol(HttpRequest request, ChannelContext channelContext) {
        Map headers = request.getHeaders();
        String Sec_WebSocket_Key = (String)headers.get("sec-websocket-key");
        if (StrUtil.isNotBlank((CharSequence)Sec_WebSocket_Key)) {
            byte[] Sec_WebSocket_Key_Bytes = null;
            try {
                Sec_WebSocket_Key_Bytes = Sec_WebSocket_Key.getBytes(request.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] allBs = new byte[Sec_WebSocket_Key_Bytes.length + SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length];
            System.arraycopy(Sec_WebSocket_Key_Bytes, 0, allBs, 0, Sec_WebSocket_Key_Bytes.length);
            System.arraycopy(SEC_WEBSOCKET_KEY_SUFFIX_BYTES, 0, allBs, Sec_WebSocket_Key_Bytes.length, SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length);
            byte[] key_array = Sha1Utils.digest((byte[])allBs);
            String acceptKey = Base64Utils.encodeToString((byte[])key_array);
            HttpResponse httpResponse = new HttpResponse(request);
            httpResponse.setStatus(HttpResponseStatus.C101);
            HashMap<HeaderName, HeaderValue> respHeaders = new HashMap<HeaderName, HeaderValue>();
            respHeaders.put(HeaderName.Connection, HeaderValue.Connection.Upgrade);
            respHeaders.put(HeaderName.Upgrade, HeaderValue.Upgrade.WebSocket);
            respHeaders.put(HeaderName.Sec_WebSocket_Accept, HeaderValue.from((String)acceptKey));
            httpResponse.addHeaders(respHeaders);
            return httpResponse;
        }
        return null;
    }
}

