/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.common;

import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.websocket.common.Opcode;
import com.litongjava.tio.websocket.common.WebSocketPacket;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketResponse
extends WebSocketPacket {
    private static Logger log = LoggerFactory.getLogger(WebSocketResponse.class);
    private static final long serialVersionUID = 963847148301021559L;

    public WebSocketResponse() {
    }

    public WebSocketResponse(byte[] jsonBytes) {
        this.setBody(jsonBytes);
        this.setWsOpcode(Opcode.TEXT);
    }

    public WebSocketResponse(String text) {
        this.setBody(text.getBytes());
        this.setWsOpcode(Opcode.TEXT);
    }

    public static WebSocketResponse fromJson(Object data) {
        WebSocketResponse wsResponse = new WebSocketResponse();
        String text = JsonUtils.toJson((Object)data);
        wsResponse.setBody(text.getBytes());
        wsResponse.setWsOpcode(Opcode.TEXT);
        return wsResponse;
    }

    public static WebSocketResponse fromText(String text) {
        WebSocketResponse wsResponse = new WebSocketResponse();
        wsResponse.setBody(text.getBytes());
        wsResponse.setWsOpcode(Opcode.TEXT);
        return wsResponse;
    }

    public static WebSocketResponse fromText(String text, String charset) {
        WebSocketResponse wsResponse = new WebSocketResponse();
        try {
            wsResponse.setBody(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        wsResponse.setWsOpcode(Opcode.TEXT);
        return wsResponse;
    }

    public static WebSocketResponse fromBytes(byte[] bytes) {
        WebSocketResponse wsResponse = new WebSocketResponse();
        wsResponse.setBody(bytes);
        wsResponse.setWsOpcode(Opcode.BINARY);
        return wsResponse;
    }
}

