/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.common;

import com.litongjava.tio.websocket.common.Opcode;
import com.litongjava.tio.websocket.common.WebSocketPacket;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketRequest
extends WebSocketPacket {
    private static final Logger log = LoggerFactory.getLogger(WebSocketRequest.class);
    private static final long serialVersionUID = -3361865570708714596L;

    public static WebSocketRequest fromText(String text, String charset) {
        WebSocketRequest wsRequest = new WebSocketRequest();
        try {
            wsRequest.setBody(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        wsRequest.setWsEof(true);
        wsRequest.setWsOpcode(Opcode.TEXT);
        return wsRequest;
    }

    public static WebSocketRequest fromBytes(byte[] bytes) {
        WebSocketRequest wsRequest = new WebSocketRequest();
        wsRequest.setBody(bytes);
        wsRequest.setWsEof(true);
        wsRequest.setWsOpcode(Opcode.BINARY);
        return wsRequest;
    }
}

