/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.common;

import java.util.HashMap;
import java.util.Map;

public enum Opcode {
    NOT_FIN(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    private static final Map<Byte, Opcode> map;
    private final byte code;

    public static Opcode valueOf(byte code) {
        return map.get(code);
    }

    private Opcode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    static {
        map = new HashMap<Byte, Opcode>();
        for (Opcode command : Opcode.values()) {
            map.put(command.getCode(), command);
        }
    }
}

