/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.thread.pool;

import com.litongjava.tio.utils.thread.pool.AbstractSynRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SynThreadPoolExecutor
extends ThreadPoolExecutor {
    private String name = null;

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory);
        this.name = name;
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, String name, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory, rejectedExecutionHandler);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBeforeExecute(Runnable runnable) {
        if (runnable instanceof AbstractSynRunnable) {
            AbstractSynRunnable synRunnable = (AbstractSynRunnable)runnable;
            if (synRunnable.executed) {
                return false;
            }
            boolean tryLock = synRunnable.runningLock.tryLock();
            if (tryLock) {
                try {
                    if (synRunnable.executed) {
                        boolean bl = false;
                        return bl;
                    }
                    synRunnable.executed = true;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    synRunnable.runningLock.unlock();
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable runnable) {
        if (runnable instanceof AbstractSynRunnable) {
            AbstractSynRunnable synRunnable = (AbstractSynRunnable)runnable;
            if (synRunnable.executed) {
                return;
            }
            boolean tryLock = synRunnable.runningLock.tryLock();
            if (!tryLock) return;
            try {
                if (synRunnable.executed) {
                    return;
                }
                synRunnable.executed = true;
                super.execute(runnable);
                return;
            }
            finally {
                synRunnable.runningLock.unlock();
            }
        } else {
            super.execute(runnable);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <R> Future<R> submit(Runnable runnable, R result) {
        if (this.checkBeforeExecute(runnable)) {
            Future<R> ret = super.submit(runnable, result);
            return ret;
        }
        return null;
    }
}

