/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.snowflake;

import java.util.Random;

public class SnowflakeIdUtils {
    private static final SnowflakeIdUtils snowflakeIdGenerator = new SnowflakeIdUtils(SnowflakeIdUtils.randomInt(1, 30), SnowflakeIdUtils.randomInt(1, 30));
    private static final long START_TIMESTAMP = 1625076000000L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATACENTER_ID_BITS = 5L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATACENTER_ID = 31L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATACENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdUtils(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException("Worker ID can't be greater than 31 or less than 0");
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException("Datacenter ID can't be greater than 31 or less than 0");
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long generateId() {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate ID");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.getNextTimestamp(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1625076000000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long getNextTimestamp(long lastTimestamp) {
        long currentTimestamp = System.currentTimeMillis();
        while (currentTimestamp <= lastTimestamp) {
            currentTimestamp = System.currentTimeMillis();
        }
        return currentTimestamp;
    }

    public static int randomInt(int min, int max) {
        Random random = new Random();
        int randomNumber = random.nextInt(max - min + 1) + min;
        return randomNumber;
    }

    public static long id() {
        return snowflakeIdGenerator.generateId();
    }
}

