/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.quartz;

import com.litongjava.tio.utils.hutool.ResourceUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzUtils {
    private static Logger log = LoggerFactory.getLogger(QuartzUtils.class);
    private static final String DEFAULT_FILE = "config/tio-quartz.properties";
    private static String file = "config/tio-quartz.properties";
    private static Scheduler scheduler;
    private static final List<QuartzTimeVo> JOB_CLASSES;

    private QuartzUtils() {
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static void start() {
        QuartzUtils.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String file1) {
        file = StrUtil.isBlank(file1) ? DEFAULT_FILE : file1;
        QuartzUtils.initJobClasses();
        if (JOB_CLASSES.size() <= 0) {
            log.error("File [{}] do not have any task", (Object)file);
            return;
        }
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            int index = 1;
            for (QuartzTimeVo quartzTimeVo : JOB_CLASSES) {
                try {
                    Class<?> clazzz = Class.forName(quartzTimeVo.getClazz());
                    JobDetail job = JobBuilder.newJob(clazzz).withIdentity("job-" + index, "group-" + index).build();
                    CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger-" + index, "group-" + index).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)quartzTimeVo.getCron())).build();
                    Date d = scheduler.scheduleJob(job, (Trigger)trigger);
                    log.info("A scheduled task has been started:{}, cron:{}", (Object)clazzz.getName(), (Object)trigger.getCronExpression());
                }
                catch (ClassNotFoundException e) {
                    log.error(e.toString(), (Throwable)e);
                }
                finally {
                    ++index;
                }
            }
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void initJobClasses() {
        Properties props = new Properties();
        try {
            props.load(ResourceUtil.getResourceAsStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        if (set != null && set.size() > 0) {
            for (Map.Entry<Object, Object> entry : set) {
                String clazz = StrUtil.trim((String)entry.getKey());
                String cron = StrUtil.trim((String)entry.getValue());
                QuartzTimeVo quartzTimeVo = new QuartzTimeVo(clazz, cron);
                JOB_CLASSES.add(quartzTimeVo);
            }
        }
    }

    public static void stop() {
        try {
            scheduler.shutdown();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    static {
        JOB_CLASSES = new ArrayList<QuartzTimeVo>(10);
    }

    private static class QuartzTimeVo {
        private String clazz = null;
        private String cron = null;

        public QuartzTimeVo(String clazz, String cron) {
            this.clazz = clazz;
            this.cron = cron;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getCron() {
            return this.cron;
        }
    }
}

