/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.quartz;

import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.hutool.DateUtil;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobWithLog
implements Job {
    private Logger log = LoggerFactory.getLogger(AbstractJobWithLog.class);
    protected int runCount = 0;
    private static Map<Class<?>, Integer> map = new HashMap();

    private Integer getAndAddRunCount(Class<?> clazz) {
        Integer ret = map.get(clazz);
        if (ret == null) {
            map.put(clazz, 1);
            this.runCount = 1;
            return 1;
        }
        Integer n = ret;
        Integer n2 = ret = Integer.valueOf(ret + 1);
        map.put(clazz, ret);
        this.runCount = ret;
        return ret;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.getAndAddRunCount(this.getClass());
        this.log.info("The {} times tasks {}, id: {}, execution : {}, last time the execution: {}, next execution: {}", new Object[]{this.runCount, this.getClass().getName(), context.getFireInstanceId(), DateUtil.formatDateTime(context.getFireTime()), DateUtil.formatDateTime(context.getPreviousFireTime()), DateUtil.formatDateTime(context.getNextFireTime())});
        long start = SystemTimer.currTime;
        try {
            this.run(context);
        }
        catch (JobExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error(e.toString(), e);
        }
        long end = SystemTimer.currTime;
        long iv = end - start;
        this.log.info("The {} times task is executed for {} times. id : {}, execution time {}, duration {}ms", new Object[]{this.runCount, this.getClass().getName(), context.getFireInstanceId(), DateUtil.formatDateTime(context.getFireTime()), iv});
    }

    public abstract void run(JobExecutionContext var1) throws Exception;
}

