/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.notification;

import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.utils.notification.NotifactionWarmModel;
import com.litongjava.tio.utils.notification.NotificationTemplate;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class LarksuiteNotificationUtils {
    public static Response send(Map<String, Object> reqMap) {
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return LarksuiteNotificationUtils.send(webHookUrl, reqMap);
    }

    public static Response send(String webHookUrl, Map<String, Object> reqMap) {
        String reqBody = JsonUtils.toJson(reqMap);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("cache-control", "no-cache");
        return HttpUtils.post(webHookUrl, header, reqBody);
    }

    public static Response sendWarm(NotifactionWarmModel model) {
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return LarksuiteNotificationUtils.sendWarm(webHookUrl, model);
    }

    public static Response sendWarm(String webHookUrl, NotifactionWarmModel model) {
        Map<String, Object> reqMap = LarksuiteNotificationUtils.getReqMap(NotificationTemplate.format(model));
        return LarksuiteNotificationUtils.send(webHookUrl, reqMap);
    }

    public static Map<String, Object> getReqMap(String msg) {
        HashMap<String, String> markdown = new HashMap<String, String>();
        markdown.put("text", msg);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("msg_type", "text");
        reqMap.put("content", markdown);
        return reqMap;
    }

    public static Response sendTextMsg(String msg) {
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("text", msg);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("msg_type", "text");
        req.put("content", text);
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return LarksuiteNotificationUtils.send(webHookUrl, req);
    }
}

