/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.monitor;

import com.litongjava.model.sys.SystemInfo;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;

public class SystemMonitorUtils {
    public static SystemInfo getSystemInfo() {
        SystemInfo info = new SystemInfo();
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        info.setAvailableProcessors(osBean.getAvailableProcessors());
        info.setSystemLoadAverage(osBean.getSystemLoadAverage());
        OperatingSystemMXBean os = (OperatingSystemMXBean)osBean;
        info.setCpuUsage((long)(os.getSystemCpuLoad() * 100.0));
        info.setTotalPhysicalMemorySize(os.getTotalPhysicalMemorySize());
        info.setFreePhysicalMemorySize(os.getFreePhysicalMemorySize());
        MemoryUsage heapMemoryUsage = memoryBean.getHeapMemoryUsage();
        info.setHeapMemoryUsed(heapMemoryUsage.getUsed());
        info.setHeapMemoryMax(heapMemoryUsage.getMax());
        MemoryUsage nonHeapMemoryUsage = memoryBean.getNonHeapMemoryUsage();
        info.setNonHeapMemoryUsed(nonHeapMemoryUsage.getUsed());
        info.setNonHeapMemoryMax(nonHeapMemoryUsage.getMax());
        info.setJavaVersion(System.getProperty("java.version"));
        info.setJvmVendor(System.getProperty("java.vendor"));
        info.setJvmUptime(runtimeBean.getUptime());
        info.setOsName(osBean.getName());
        info.setOsVersion(osBean.getVersion());
        info.setOsArch(osBean.getArch());
        File[] roots = File.listRoots();
        info.setFileRoots(roots);
        return info;
    }
}

