/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.mcid;

public class McIdGenerator {
    private final int machineId;
    private int sequence = 0;
    private long lastTimestamp = -1L;

    public McIdGenerator(int machineId) {
        if (machineId < 0 || machineId > 255) {
            throw new IllegalArgumentException("Machine ID must be between 0 and 255");
        }
        this.machineId = machineId;
    }

    public synchronized long generateId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1 & 0xF;
            if (this.sequence == 0) {
                while (System.currentTimeMillis() <= timestamp) {
                }
                timestamp = System.currentTimeMillis();
            }
        } else {
            this.sequence = 0;
        }
        this.lastTimestamp = timestamp;
        return (timestamp & 0x1FFFFFFFFFFL) << 12 | (long)(this.machineId << 4) | (long)this.sequence;
    }
}

