/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.jwt;

import com.litongjava.model.token.AuthToken;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtils {
    public static final String dot_delimiter = "\\.";
    public static final String colon_delimiter = ":";

    public static AuthToken createToken(String key, AuthToken authToken) {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("userId", authToken.getUserId());
        payloadMap.put("exp", authToken.getExpirationTime());
        String createToken = JwtUtils.createToken(key, payloadMap);
        authToken.setToken(createToken);
        return authToken;
    }

    public static String createTokenByUserId(String key, Object userId) {
        long tokenTimeout = (System.currentTimeMillis() + 3600000L) / 1000L;
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("userId", userId);
        payloadMap.put("exp", tokenTimeout);
        return JwtUtils.createToken(key, payloadMap);
    }

    public static String createTokenByUserId(String key, Object userId, long tokenTimeout) {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("userId", userId);
        payloadMap.put("exp", tokenTimeout);
        return JwtUtils.createToken(key, payloadMap);
    }

    public static String createToken(String key, Map<String, Object> payloadMap) {
        String header = Base64.getUrlEncoder().encodeToString("{\"alg\":\"HS256\",\"typ\":\"JWT\"}".getBytes(StandardCharsets.UTF_8));
        String payload = Base64.getUrlEncoder().encodeToString(JwtUtils.toJson(payloadMap).getBytes(StandardCharsets.UTF_8));
        String signature = JwtUtils.hmacSha256(header + "." + payload, key);
        return header + "." + payload + "." + signature;
    }

    private static String toJson(Map<String, Object> payloadMap) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        int size = payloadMap.size();
        int i = 0;
        for (Map.Entry<String, Object> entry : payloadMap.entrySet()) {
            json.append("\"").append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof String) {
                json.append("\"").append(value).append("\"");
            } else {
                json.append(value);
            }
            if (i < size - 1) {
                json.append(",");
            }
            ++i;
        }
        json.append("}");
        return json.toString();
    }

    public static boolean verify(String key, String token, String delimiter) {
        String[] parts = token.split(delimiter);
        if (parts.length != 3) {
            return false;
        }
        String header = parts[0];
        String payload = parts[1];
        String signature = parts[2];
        String calculatedSignature = null;
        calculatedSignature = colon_delimiter.equals(delimiter) ? JwtUtils.hmacSha256(header + colon_delimiter + payload, key) : JwtUtils.hmacSha256(header + "." + payload, key);
        String decodedPayload = new String(Base64.getUrlDecoder().decode(payload), StandardCharsets.UTF_8);
        return signature.equals(calculatedSignature) && !JwtUtils.isTokenExpired(decodedPayload);
    }

    public static boolean verify(String key, String token) {
        return JwtUtils.verify(key, token, dot_delimiter);
    }

    public static Map<String, Object> getPayload(String token, String delimiter) {
        String[] parts = token.split(delimiter);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid JWT token");
        }
        String payload = parts[1];
        String decodedPayload = new String(Base64.getUrlDecoder().decode(payload), StandardCharsets.UTF_8);
        return JwtUtils.parsePayload(decodedPayload);
    }

    public static Map<String, Object> getPayload(String token) {
        return JwtUtils.getPayload(token, dot_delimiter);
    }

    private static String hmacSha256(String data, String secret) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hash = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC SHA256", e);
        }
    }

    private static boolean isTokenExpired(String payload) {
        Map<String, Object> payloadMap = JwtUtils.parsePayload(payload);
        long exp = (Long)payloadMap.get("exp");
        if (exp == -1L) {
            return false;
        }
        return exp < System.currentTimeMillis() / 1000L;
    }

    private static Map<String, Object> parsePayload(String payload) {
        String[] pairs;
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payload = payload.substring(1, payload.length() - 1);
        for (String pair : pairs = payload.split(",")) {
            String[] keyValue = pair.split(colon_delimiter);
            String key = keyValue[0].trim().replaceAll("\"", "");
            Object value = keyValue[1].trim();
            try {
                value = Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                value = value.toString().replaceAll("\"", "");
            }
            payloadMap.put(key, value);
        }
        return payloadMap;
    }

    public static AuthToken getAuthToken(String token) {
        String[] parts = token.split(dot_delimiter);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid JWT token");
        }
        String payload = parts[1];
        String decodedPayload = new String(Base64.getUrlDecoder().decode(payload), StandardCharsets.UTF_8);
        AuthToken authToken = JwtUtils.parseToAuthToken(decodedPayload);
        authToken.setToken(token);
        return authToken;
    }

    private static AuthToken parseToAuthToken(String payload) {
        String[] pairs;
        AuthToken authToken = new AuthToken();
        payload = payload.substring(1, payload.length() - 1);
        for (String pair : pairs = payload.split(",")) {
            String[] keyValue = pair.split(colon_delimiter);
            String key = keyValue[0].trim().replaceAll("\"", "");
            String value = keyValue[1].trim();
            if ("userId".equals(key)) {
                authToken.setUserId((Object)value);
                continue;
            }
            if (!"exp".equals(key)) continue;
            Long exp = Long.parseLong(value);
            authToken.setExpirationTime(exp.longValue());
        }
        return authToken;
    }

    public static Long parseUserIdLong(String token) {
        Map<String, Object> payload = JwtUtils.getPayload(token);
        return (Long)payload.get("userId");
    }

    public static String parseUserIdString(String token) {
        Map<String, Object> payload = JwtUtils.getPayload(token);
        return (String)payload.get("userId");
    }

    public static Integer parseUserIdInt(String token) {
        Map<String, Object> payload = JwtUtils.getPayload(token);
        return (Integer)payload.get("userId");
    }

    public static Object parseUserId(String token) {
        Map<String, Object> payload = JwtUtils.getPayload(token);
        return payload.get("userId");
    }
}

