/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.litongjava.tio.utils.date.TioTimeUtils;
import com.litongjava.tio.utils.json.TioJsonKit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public class JsonResult {
    Map<String, SimpleDateFormat> formats = new HashMap<String, SimpleDateFormat>();
    StringBuilder sb = new StringBuilder();
    String datePattern;
    String timestampPattern;
    boolean longToString;
    boolean inUse = false;

    public void init(String datePattern, String timestampPattern) {
        this.datePattern = datePattern;
        this.timestampPattern = timestampPattern;
        this.inUse = true;
    }

    public void init(String dp, String timestampPattern, boolean longToString) {
        this.datePattern = dp;
        this.timestampPattern = timestampPattern;
        this.longToString = longToString;
        this.inUse = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void clear() {
        this.inUse = false;
        if (this.sb.length() > TioJsonKit.maxBufferSize) {
            this.sb = new StringBuilder(Math.max(1024, TioJsonKit.maxBufferSize / 2));
        } else {
            this.sb.setLength(0);
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes() {
        IntStream intStream = this.sb.chars();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            intStream.forEach(c -> baos.write(c));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int length() {
        return this.sb.length();
    }

    public void addChar(char ch) {
        this.sb.append(ch);
    }

    public void addNull() {
        this.sb.append("null");
    }

    public void addStr(String str) {
        TioJsonKit.escape(str, this.sb);
    }

    public void addStrNoEscape(String str) {
        this.sb.append('\"').append(str).append('\"');
    }

    public void addInt(int i) {
        this.sb.append(i);
    }

    public void addLong(long l) {
        if (this.longToString) {
            this.sb.append("\"" + l + "\"");
        } else {
            this.sb.append(l);
        }
    }

    public void addDouble(double d) {
        this.sb.append(d);
    }

    public void addFloat(float f) {
        this.sb.append(f);
    }

    public void addNumber(Number n) {
        this.sb.append(n.toString());
    }

    public void addBoolean(boolean b) {
        this.sb.append(b);
    }

    public void addEnum(Enum en) {
        this.sb.append('\"').append(en.toString()).append('\"');
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public SimpleDateFormat getFormat(String pattern) {
        SimpleDateFormat ret = this.formats.get(pattern);
        if (ret == null) {
            ret = new SimpleDateFormat(pattern);
            this.formats.put(pattern, ret);
        }
        return ret;
    }

    public void addTime(Time t) {
        this.sb.append('\"').append(t.toString()).append('\"');
    }

    public void addTimestamp(Timestamp ts) {
        if (this.timestampPattern != null) {
            this.sb.append('\"').append(this.getFormat(this.timestampPattern).format(ts)).append('\"');
        } else {
            this.sb.append(ts.getTime());
        }
    }

    public void addDate(Date d) {
        if (this.datePattern != null) {
            this.sb.append('\"').append(this.getFormat(this.datePattern).format(d)).append('\"');
        } else {
            this.sb.append(d.getTime());
        }
    }

    public void addLocalDateTime(LocalDateTime ldt) {
        if (this.datePattern != null) {
            this.sb.append('\"').append(TioTimeUtils.format(ldt, this.datePattern)).append('\"');
        } else {
            this.sb.append(TioTimeUtils.toDate(ldt).getTime());
        }
    }

    public void addLocalDate(LocalDate ld) {
        String dp = "yyyy-MM-dd";
        this.sb.append('\"').append(TioTimeUtils.format(ld, dp)).append('\"');
    }

    public void addLocalTime(LocalTime lt) {
        String tp = "HH:mm:ss";
        this.sb.append('\"').append(TioTimeUtils.format(lt, tp)).append('\"');
    }

    public void addMapKey(Object value) {
        TioJsonKit.escape(String.valueOf(value), this.sb);
    }

    public void addUnknown(Object obj) {
        TioJsonKit.escape(obj.toString(), this.sb);
    }
}

