/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.utils.json.Json;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GsonJson
extends Json {
    private Gson gson = new Gson();

    @Override
    public String toJson(Object object) {
        return this.gson.toJson(object);
    }

    @Override
    public byte[] toJsonBytes(Object object) {
        return this.gson.toJson(object).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        return (T)this.gson.fromJson(jsonString, type);
    }

    @Override
    public Map<?, ?> parseToMap(String json) {
        Type mapType = new TypeToken<Map<?, ?>>(){}.getType();
        return (Map)this.gson.fromJson(json, mapType);
    }

    @Override
    public <K, V> Map<K, V> parseToMap(String json, Class<K> kType, Class<V> vType) {
        Type mapType = new TypeToken<Map<K, V>>(){}.getType();
        return (Map)this.gson.fromJson(json, mapType);
    }

    @Override
    public Object parseObject(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonString);
        return jsonElement.getAsJsonObject();
    }

    @Override
    public Object parseArray(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonString);
        return jsonElement.getAsJsonArray();
    }

    @Override
    public <T> List<T> parseArray(String str, Class<T> elementType) {
        Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{elementType}).getType();
        return (List)this.gson.fromJson(str, type);
    }

    @Override
    public <K, V> List<Map<K, V>> parseToListMap(String stringValue, Class<K> kType, Class<V> vType) {
        Type mapType = new TypeToken<Map<K, V>>(){}.getType();
        JsonArray jsonArray = JsonParser.parseString((String)stringValue).getAsJsonArray();
        ArrayList<Map<K, V>> listMap = new ArrayList<Map<K, V>>();
        for (JsonElement jsonElement : jsonArray) {
            Map map = (Map)this.gson.fromJson(jsonElement, mapType);
            listMap.add(map);
        }
        return listMap;
    }

    @Override
    public Object parse(String stringValue) {
        return this.gson.fromJson(stringValue, Object.class);
    }

    @Override
    public <T> T parse(String body, Type type) {
        return (T)this.gson.fromJson(body, type);
    }

    @Override
    public <T> T parse(byte[] body, Type type) {
        String bodyString = new String(body);
        return (T)this.gson.fromJson(bodyString, type);
    }

    @Override
    public <T> T parse(String body, TioTypeReference<T> tioTypeReference) {
        return (T)this.gson.fromJson(body, tioTypeReference.getType());
    }
}

