/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FastJson2Utils {
    public static String toJson(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static byte[] toJSONBytes(Object input) {
        return JSON.toJSONBytes((Object)input);
    }

    public static String toJson(Object input, JSONWriter.Feature ... features) {
        return JSON.toJSONString((Object)input, (JSONWriter.Feature[])features);
    }

    public static byte[] toJSONBytes(Object input, JSONWriter.Feature ... features) {
        return JSON.toJSONBytes((Object)input, (JSONWriter.Feature[])features);
    }

    public static <T> T parse(String jsonString, Class<T> type) {
        return (T)JSON.parseObject((String)jsonString, type);
    }

    public static <T> T parse(byte[] input, Class<T> type) {
        return (T)JSON.parseObject((byte[])input, type);
    }

    public static JSONObject parseObject(String bodyString) {
        return JSON.parseObject((String)bodyString);
    }

    public static JSONObject parseObject(byte[] bytes) {
        return JSON.parseObject((byte[])bytes);
    }

    public static JSONArray parseArray(String jsonString) {
        return JSON.parseArray((String)jsonString);
    }

    public static JSONArray parseArray(byte[] input) {
        return JSON.parseArray((byte[])input);
    }

    public static <T> List<T> parseArray(String jsonString, Class<T> clazz) {
        return JSON.parseArray((String)jsonString, clazz);
    }

    public static <T> List<T> parseArray(byte[] input, Class<T> clazz) {
        return JSON.parseArray((byte[])input, clazz, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    public static Map<?, ?> parseToMap(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    public static <K, V> Map<K, V> parseToMap(String json, Class<K> kType, Class<V> vType) {
        TypeReference typeReference = new TypeReference<Map<K, V>>(){};
        Map map = (Map)JSON.parseObject((String)json, (TypeReference)typeReference, (JSONReader.Feature[])new JSONReader.Feature[0]);
        return map;
    }

    public static <K, V> List<Map<K, V>> parseToListMap(String stringValue, Class<K> kType, Class<V> vType) {
        TypeReference typeReference = new TypeReference<Map<K, V>>(){};
        JSONArray jsonArray = JSON.parseArray((String)stringValue);
        ArrayList<Map<K, V>> listMap = new ArrayList<Map<K, V>>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Map map = (Map)jsonArray.getJSONObject(i).to(typeReference, new JSONReader.Feature[0]);
            listMap.add(map);
        }
        return listMap;
    }
}

