/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.utils.json.Json;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FastJson2
extends Json {
    public static FastJson2 getJson() {
        return new FastJson2();
    }

    @Override
    public String toJson(Object object) {
        if (Json.isLongToString()) {
            return JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteLongAsString});
        }
        return JSON.toJSONString((Object)object);
    }

    @Override
    public byte[] toJsonBytes(Object input) {
        if (Json.isLongToString()) {
            return JSON.toJSONBytes((Object)input, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteLongAsString});
        }
        return JSON.toJSONBytes((Object)input);
    }

    public String toJson(Object object, JSONWriter.Feature ... features) {
        return JSON.toJSONString((Object)object, (JSONWriter.Feature[])features);
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        return (T)JSON.parseObject((String)jsonString, type);
    }

    @Override
    public Map<?, ?> parseToMap(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public <K, V> Map<K, V> parseToMap(String json, Class<K> kType, Class<V> vType) {
        TypeReference typeReference = new TypeReference<Map<K, V>>(){};
        Map map = (Map)JSON.parseObject((String)json, (TypeReference)typeReference, (JSONReader.Feature[])new JSONReader.Feature[0]);
        return map;
    }

    @Override
    public Object parseObject(String jsonString) {
        return JSON.parseObject((String)jsonString);
    }

    @Override
    public Object parseArray(String jsonString) {
        return JSON.parseArray((String)jsonString);
    }

    @Override
    public <K, V> List<Map<K, V>> parseToListMap(String stringValue, Class<K> kType, Class<V> vType) {
        TypeReference typeReference = new TypeReference<Map<K, V>>(){};
        JSONArray jsonArray = JSON.parseArray((String)stringValue);
        ArrayList<Map<K, V>> listMap = new ArrayList<Map<K, V>>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Map map = (Map)jsonArray.getJSONObject(i).to(typeReference, new JSONReader.Feature[0]);
            listMap.add(map);
        }
        return listMap;
    }

    @Override
    public Object parse(String stringValue) {
        return JSON.parse((String)stringValue);
    }

    @Override
    public <T> T parse(String body, Type type) {
        return (T)JSON.parseObject((String)body, (Type)type);
    }

    @Override
    public <T> T parse(byte[] body, Type type) {
        return (T)JSON.parseObject((byte[])body, (Type)type);
    }

    @Override
    public <T> List<T> parseArray(String str, Class<T> elementType) {
        return JSON.parseArray((String)str, elementType);
    }

    @Override
    public <T> T parse(String body, TioTypeReference<T> tioTypeReference) {
        return (T)JSON.parseObject((String)body, (Type)tioTypeReference.getType());
    }
}

