/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hutool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataMaskingUtil {
    public static String maskName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() == 1) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            sb.append("*");
        }
        return sb.toString();
    }

    public static String maskEmail(String email) {
        if (email == null || email.isEmpty()) {
            return email;
        }
        int atIndex = email.indexOf("@");
        if (atIndex <= 1) {
            return email.replaceAll(".", "*");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(email.charAt(0));
        for (int i = 1; i < atIndex; ++i) {
            sb.append("*");
        }
        sb.append(email.substring(atIndex));
        return sb.toString();
    }

    public static String maskPhone(String phone) {
        if (phone == null || phone.isEmpty()) {
            return phone;
        }
        return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String maskIdCard(String idCard) {
        if (idCard == null || idCard.isEmpty()) {
            return idCard;
        }
        if (idCard.length() < 10) {
            return idCard.replaceAll(".", "*");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(idCard.substring(0, 6));
        for (int i = 6; i < idCard.length() - 4; ++i) {
            sb.append("*");
        }
        sb.append(idCard.substring(idCard.length() - 4));
        return sb.toString();
    }

    public static String maskCreditCard(String creditCard) {
        if (creditCard == null || creditCard.isEmpty()) {
            return creditCard;
        }
        String sanitized = creditCard.replaceAll("\\s+", "");
        if (sanitized.length() < 8) {
            return sanitized.replaceAll(".", "*");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sanitized.substring(0, 4));
        sb.append(" **** **** ");
        sb.append(sanitized.substring(sanitized.length() - 4));
        return sb.toString();
    }

    public static String maskApiKey(String apiKey) {
        if (apiKey == null || apiKey.isEmpty()) {
            return apiKey;
        }
        Pattern pattern = Pattern.compile("^([A-Za-z0-9]{7})([A-Za-z0-9]+)([A-Za-z0-9]{4})$");
        Matcher matcher = pattern.matcher(apiKey);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            String maskedMiddle = matcher.group(2).replaceAll(".", "*");
            String suffix = matcher.group(3);
            return prefix + maskedMiddle + suffix;
        }
        if (apiKey.length() <= 8) {
            return apiKey.replaceAll(".", "*");
        }
        String prefix = apiKey.substring(0, 4);
        String suffix = apiKey.substring(apiKey.length() - 4);
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 4; i < apiKey.length() - 4; ++i) {
            sb.append("*");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String maskStr(String text) {
        return DataMaskingUtil.maskByRegex(text, "(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String maskByRegex(String original, String regex, String replacement) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(original);
        return matcher.replaceAll(replacement);
    }
}

