/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.http;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;

public class Http {
    public static ResponseVo postJson(String url, Map<String, String> params) {
        String payload = JsonUtils.toJson(params);
        return Http.postJson(url, payload, null);
    }

    public static ResponseVo postJson(String serverUrl, String payload) {
        return Http.postJson(serverUrl, payload, null);
    }

    public static ResponseVo postJson(String serverUrl, String payload, Map<String, String> headers) {
        URL url = null;
        try {
            url = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + serverUrl, e);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = payload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            os = Http.handleResponse(conn);
            return os;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send POST JSON request to " + serverUrl, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static ResponseVo post(String serverUrl, Map<String, String> params) {
        return Http.post(serverUrl, params, null);
    }

    public static ResponseVo post(String serverUrl, Map<String, String> params, Map<String, String> headers) {
        URL url;
        try {
            url = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + serverUrl, e);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (headers != null) {
                for (Map.Entry<String, String> entry2 : headers.entrySet()) {
                    conn.setRequestProperty(entry2.getKey(), entry2.getValue());
                }
            }
            String formParams = params.entrySet().stream().map(entry -> Http.encodeURIComponent((String)entry.getKey()) + "=" + Http.encodeURIComponent((String)entry.getValue())).collect(Collectors.joining("&"));
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = formParams.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            ResponseVo responseVo = Http.handleResponse(conn);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send POST request to " + serverUrl, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static ResponseVo get(String serverUrl) {
        return Http.get(serverUrl, null);
    }

    public static ResponseVo get(String serverUrl, Map<String, String> headers) {
        URL url;
        try {
            url = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + serverUrl, e);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            ResponseVo responseVo = Http.handleResponse(conn);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send GET request to " + serverUrl, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static ResponseVo handleResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        InputStream inputStream = null;
        if (responseCode >= 200 && responseCode < 300) {
            inputStream = conn.getInputStream();
        } else {
            inputStream = conn.getErrorStream();
            if (inputStream == null) {
                return ResponseVo.fail((int)responseCode, (String)"No error message available");
            }
        }
        String responseBody = new String(Http.readInputStream(inputStream), StandardCharsets.UTF_8);
        return responseCode == 200 ? ResponseVo.ok((int)responseCode, (String)responseBody) : ResponseVo.fail((int)responseCode, (String)responseBody);
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private static String encodeURIComponent(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode parameter: " + s, e);
        }
    }
}

