/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.environment;

import com.litongjava.tio.utils.environment.PropUtils;
import com.litongjava.tio.utils.hutool.ResourceUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtils {
    private static final Logger log = LoggerFactory.getLogger(EnvUtils.class);
    private static String[] args;
    private static Map<String, String> cmdArgsMap;
    private static Map<String, String> appMap;
    public static final String defaultFilename = "app.properties";
    public static final String envKey = "app.env";

    public static String[] getArgs() {
        return args;
    }

    public Map<String, String> getCmdArgsMap() {
        return cmdArgsMap;
    }

    public static boolean isDevMode() {
        URL resource = EnvUtils.class.getClassLoader().getResource("");
        return resource != null && resource.toString().endsWith("/target/classes/");
    }

    public static Map<String, String> buildCmdArgsMap(String[] args) {
        EnvUtils.args = args;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : args) {
            String[] parts;
            if (!arg.startsWith("--") || (parts = arg.substring(2).split("=", 2)).length != 2) continue;
            result.put(parts[0], parts[1]);
        }
        cmdArgsMap = result;
        return result;
    }

    public static String getStr(String key) {
        String value = appMap.get(key);
        if (value != null) {
            return value;
        }
        value = cmdArgsMap.get(key);
        if (value != null) {
            return value;
        }
        value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key.replace(".", "_").toUpperCase());
        if (value != null) {
            return value;
        }
        if (PropUtils.isLoad()) {
            value = PropUtils.get(key);
        }
        return value;
    }

    public static String get(String key) {
        return EnvUtils.getStr(key);
    }

    public static String getStr(String key, String defaultValue) {
        return EnvUtils.get(key, defaultValue);
    }

    public static String get(String key, String defaultValue) {
        String value = EnvUtils.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int getInt(String key) {
        String value = EnvUtils.getStr(key);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    public static int getInt(String key, int defaultValue) {
        String value = EnvUtils.get(key);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static Integer getInteger(String key) {
        String value = EnvUtils.getStr(key);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        String value = EnvUtils.get(key);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static Long getLong(String key) {
        String value = EnvUtils.getStr(key);
        if (value != null) {
            return Long.valueOf(value);
        }
        return null;
    }

    public static Long getLong(String key, Long defaultValue) {
        String value = EnvUtils.get(key);
        if (value != null) {
            return Long.valueOf(value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(EnvUtils.get(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = EnvUtils.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String getEnv() {
        return EnvUtils.getStr(envKey);
    }

    public static String env() {
        return EnvUtils.getStr(envKey);
    }

    public static boolean isDev() {
        return "dev".equals(EnvUtils.getStr(envKey));
    }

    public static boolean isLocal() {
        return "local".equals(EnvUtils.getStr(envKey));
    }

    public static boolean isTest() {
        return "test".equals(EnvUtils.getStr(envKey));
    }

    public static boolean isProd() {
        return "prod".equals(EnvUtils.getStr(envKey));
    }

    public static void use(String envName) {
        EnvUtils.set(envKey, envName);
    }

    public static void useDev() {
        EnvUtils.set(envKey, "dev");
    }

    public static void useLocal() {
        EnvUtils.set(envKey, "local");
    }

    public static void useTest() {
        EnvUtils.set(envKey, "test");
    }

    public static void useProd() {
        EnvUtils.set(envKey, "prod");
    }

    public static void load(String fileName) {
        PropUtils.use(fileName);
    }

    public static void load(String env, String filename) {
        PropUtils.use(filename, env);
    }

    public static void set(String key, String value) {
        appMap.put(key, value);
    }

    public static void load() {
        File secretsFile;
        File file;
        String env = EnvUtils.get(envKey);
        if (ResourceUtil.getResource(defaultFilename) != null) {
            PropUtils.use(defaultFilename, env);
            log.info("load:{}", (Object)defaultFilename);
        } else if (env != null) {
            String fileName = "app-" + env + ".properties";
            log.info("load:{}", (Object)fileName);
            PropUtils.use(fileName);
        } else {
            PropUtils.use(defaultFilename);
            log.info("load:{}", (Object)defaultFilename);
        }
        if (ResourceUtil.getResource(".env") != null) {
            log.info("load from classpath:{}", (Object)".env");
            PropUtils.append(".env");
        }
        if ((file = new File(".env")).exists()) {
            PropUtils.append(file);
            log.info("load from path:{}", (Object)".env");
        }
        if ((secretsFile = new File("secrets.txt")).exists()) {
            PropUtils.append(secretsFile);
            log.info("load from path:{}", (Object)"secrets.txt");
        }
        log.info("app.env:{} app.name:{}", (Object)EnvUtils.env(), (Object)EnvUtils.get("app.name"));
    }

    static {
        cmdArgsMap = new HashMap<String, String>();
        appMap = new HashMap<String, String>();
    }
}

