/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.crypto;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    private static byte[] toBytes(String content, String charset) {
        if (charset == null || charset.isEmpty()) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error during MD5 processing: the specified charset is invalid: " + charset, e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexDigits = "0123456789abcdef".toCharArray();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            sb.append(hexDigits[high]).append(hexDigits[low]);
        }
        return sb.toString();
    }

    public static String md5Hex(String input) {
        return Md5Utils.md5Hex(input, DEFAULT_CHARSET);
    }

    public static String md5Hex(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(data);
            return Md5Utils.bytesToHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get MD5 MessageDigest instance.", e);
        }
    }

    public static String sign(String text, String key, String inputCharset) {
        String combined = text + key;
        byte[] bytes = Md5Utils.toBytes(combined, inputCharset);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytes);
            return Md5Utils.bytesToHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get MD5 MessageDigest instance.", e);
        }
    }

    public static boolean verify(String text, String signature, String key, String inputCharset) {
        String computed = Md5Utils.sign(text, key, inputCharset);
        return computed.equals(signature);
    }

    public static String md5Hex(String input, String charset) {
        byte[] bytes = Md5Utils.toBytes(input, charset);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytes);
            return Md5Utils.bytesToHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get MD5 MessageDigest instance.", e);
        }
    }
}

