/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.redis;

import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.redis.RedisExpireUpdateTask;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioRedisCache
extends AbsCache {
    private static Logger log = LoggerFactory.getLogger(TioRedisCache.class);
    public static final String SPLIT_FOR_CACHENAME = ":";
    private RedissonClient redisson = null;
    private Long timeToLiveSeconds = null;
    private Long timeToIdleSeconds = null;
    private Long timeout = null;

    public static String cacheKey(String cacheName, String key) {
        return TioRedisCache.keyPrefix(cacheName) + key;
    }

    public static String keyPrefix(String cacheName) {
        return cacheName + SPLIT_FOR_CACHENAME;
    }

    public TioRedisCache(RedissonClient redisson, String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        super(cacheName);
        this.redisson = redisson;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeout = this.timeToLiveSeconds == null ? this.timeToIdleSeconds : this.timeToLiveSeconds;
    }

    public void clear() {
        long start = SystemTimer.currTime;
        RKeys keys = this.redisson.getKeys();
        keys.deleteByPatternAsync(TioRedisCache.keyPrefix(this.cacheName) + "*");
        long end = SystemTimer.currTime;
        long iv = end - start;
        log.info("clear cache {}, cost {}ms", (Object)this.cacheName, (Object)iv);
    }

    @Override
    public Serializable _get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        if (bucket == null) {
            log.error("bucket is null, key:{}", (Object)key);
            return null;
        }
        Serializable ret = (Serializable)bucket.get();
        if (this.timeToIdleSeconds != null && ret != null) {
            RedisExpireUpdateTask.add(this.cacheName, key, this.timeout);
        }
        return ret;
    }

    public RBucket<Serializable> getBucket(String key) {
        key = TioRedisCache.cacheKey(this.cacheName, key);
        RBucket bucket = this.redisson.getBucket(key);
        return bucket;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public Long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    @Override
    public Long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public Iterable<String> keys() {
        RKeys keys = this.redisson.getKeys();
        Iterable allkey = keys.getKeysByPattern(TioRedisCache.keyPrefix(this.cacheName) + "*");
        return allkey;
    }

    public Collection<String> keysCollection() {
        RKeys keys = this.redisson.getKeys();
        Iterable allKeys = keys.getKeysByPattern(TioRedisCache.keyPrefix(this.cacheName) + "*");
        ArrayList<String> keyCollection = new ArrayList<String>();
        for (String key : allKeys) {
            keyCollection.add(key);
        }
        return keyCollection;
    }

    public void put(String key, Serializable value) {
        long ttl;
        if (StrUtil.isBlank(key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        long _timeout = this.timeout;
        if (this.timeToLiveSeconds != null && this.timeToLiveSeconds > 0L && (ttl = this.ttl(key)) > 0L) {
            _timeout = ttl / 1000L;
        }
        bucket.set((Object)value, _timeout, TimeUnit.SECONDS);
    }

    public void putTemporary(String key, Serializable value) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        bucket.set((Object)value, 10L, TimeUnit.SECONDS);
    }

    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        bucket.delete();
    }

    public long ttl(String key) {
        RBucket<Serializable> bucket = this.getBucket(key);
        if (bucket == null) {
            return -2L;
        }
        long remainTimeToLive = bucket.remainTimeToLive();
        return remainTimeToLive;
    }

    public Map<String, Serializable> asMap() {
        return null;
    }

    public long size() {
        RKeys keys = this.redisson.getKeys();
        Iterable allkeys = keys.getKeysByPattern(TioRedisCache.keyPrefix(this.cacheName) + "*");
        long count = 0L;
        for (String key : allkeys) {
            ++count;
        }
        return count;
    }
}

