/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.mapcache;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.CacheRemovalListener;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.mapcache.ConcurrentMapCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ConcurrentMapCacheFactory implements CacheFactory
{
    INSTANCE;

    private Map<String, ConcurrentMapCache> map = new ConcurrentHashMap<String, ConcurrentMapCache>();

    @Override
    public ConcurrentMapCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        return this.map.computeIfAbsent(cacheName, k -> new ConcurrentMapCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, null));
    }

    @Override
    public <T> ConcurrentMapCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        if (removalListenerWrapper != null) {
            if (removalListenerWrapper.getListener() instanceof CacheRemovalListener) {
                return this.map.computeIfAbsent(cacheName, k -> new ConcurrentMapCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, (CacheRemovalListener)removalListenerWrapper.getListener()));
            }
            return this.map.computeIfAbsent(cacheName, k -> new ConcurrentMapCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, null));
        }
        return this.map.computeIfAbsent(cacheName, k -> new ConcurrentMapCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, null));
    }

    @Override
    public ConcurrentMapCache getCache(String cacheName, boolean skipNull) {
        return this.map.get(cacheName);
    }

    @Override
    public ConcurrentMapCache getCache(String cacheName) {
        return this.map.get(cacheName);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public ConcurrentMapCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds(), (RemovalListenerWrapper)null);
    }
}

