/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.guavaredis;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheChangeType;
import com.litongjava.tio.utils.cache.CacheChangedVo;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.guava.GuavaCache;
import com.litongjava.tio.utils.cache.guava.GuavaCacheFactory;
import com.litongjava.tio.utils.cache.guavaredis.GuavaRedisCache;
import com.litongjava.tio.utils.cache.redis.RedisCacheFactory;
import com.litongjava.tio.utils.cache.redis.TioRedisCache;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GuavaRedisCacheFactory implements CacheFactory
{
    INSTANCE;

    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, GuavaRedisCache> map = new HashMap<String, GuavaRedisCache>();
    private boolean inited = false;
    private RedissonClient redisson;
    private RTopic topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(RedissonClient redisson) {
        if (this.inited) return;
        Class<GuavaRedisCache> clazz = GuavaRedisCache.class;
        synchronized (GuavaRedisCache.class) {
            if (this.inited) return;
            this.topic = redisson.getTopic("TIO_CACHE_CHANGE_TOPIC_GUAVA");
            this.addListener(this.topic);
            this.inited = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void addListener(RTopic topic) {
        topic.addListener(CacheChangedVo.class, (MessageListener)new MessageListener<CacheChangedVo>(){

            public void onMessage(CharSequence channel, CacheChangedVo cacheChangedVo) {
                String clientid = cacheChangedVo.getClientId();
                if (StrUtil.isBlank(clientid)) {
                    GuavaRedisCacheFactory.this.log.error("clientid is null");
                    return;
                }
                if (Objects.equals(CacheChangedVo.CLIENTID, clientid)) {
                    GuavaRedisCacheFactory.this.log.debug("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f,{}", (Object)clientid);
                    return;
                }
                String cacheName = cacheChangedVo.getCacheName();
                GuavaRedisCache guavaRedisCache = GuavaRedisCacheFactory.this.getCache(cacheName);
                if (guavaRedisCache == null) {
                    GuavaRedisCacheFactory.this.log.info("\u4e0d\u80fd\u6839\u636ecacheName[{}]\u627e\u5230GuavaRedisCache\u5bf9\u8c61", (Object)cacheName);
                    return;
                }
                CacheChangeType type = cacheChangedVo.getType();
                if (type == CacheChangeType.PUT || type == CacheChangeType.UPDATE || type == CacheChangeType.REMOVE) {
                    String key = cacheChangedVo.getKey();
                    guavaRedisCache.guavaCache.remove(key);
                } else if (type == CacheChangeType.CLEAR) {
                    guavaRedisCache.guavaCache.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GuavaRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        this.init(this.redisson);
        GuavaRedisCache guavaRedisCache = this.map.get(cacheName);
        if (guavaRedisCache != null) return guavaRedisCache;
        Class<GuavaRedisCache> clazz = GuavaRedisCache.class;
        synchronized (GuavaRedisCache.class) {
            guavaRedisCache = this.map.get(cacheName);
            if (guavaRedisCache != null) return guavaRedisCache;
            RedisCacheFactory.INSTANCE.setRedisson(this.redisson);
            TioRedisCache redisCache = RedisCacheFactory.INSTANCE.register(cacheName, timeToLiveSeconds, timeToIdleSeconds);
            Long timeToLiveSecondsForCaffeine = timeToLiveSeconds;
            Long timeToIdleSecondsForCaffeine = timeToIdleSeconds;
            if (timeToLiveSecondsForCaffeine != null) {
                timeToLiveSecondsForCaffeine = Math.min(timeToLiveSecondsForCaffeine, 600L);
            }
            if (timeToIdleSecondsForCaffeine != null) {
                timeToIdleSecondsForCaffeine = Math.min(timeToIdleSecondsForCaffeine, 600L);
            }
            GuavaCache GuavaCache2 = GuavaCacheFactory.INSTANCE.register(cacheName, timeToLiveSecondsForCaffeine, timeToIdleSecondsForCaffeine);
            guavaRedisCache = new GuavaRedisCache(cacheName, GuavaCache2, redisCache);
            guavaRedisCache.setTopic(this.topic);
            guavaRedisCache.setTimeToIdleSeconds(timeToIdleSeconds);
            guavaRedisCache.setTimeToLiveSeconds(timeToLiveSeconds);
            this.map.put(cacheName, guavaRedisCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return guavaRedisCache;
        }
    }

    @Override
    public <T> GuavaRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        return null;
    }

    @Override
    public GuavaRedisCache getCache(String cacheName, boolean skipNull) {
        GuavaRedisCache guavaRedisCache = this.map.get(cacheName);
        if (guavaRedisCache == null && !skipNull) {
            this.log.error("cacheName[{}] is not yet registered, please register first.", (Object)cacheName);
        }
        return guavaRedisCache;
    }

    @Override
    public GuavaRedisCache getCache(String cacheName) {
        return this.getCache(cacheName, false);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public GuavaRedisCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds());
    }
}

