/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.guavaredis;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheChangeType;
import com.litongjava.tio.utils.cache.CacheChangedVo;
import com.litongjava.tio.utils.cache.guava.GuavaCache;
import com.litongjava.tio.utils.cache.redis.RedisExpireUpdateTask;
import com.litongjava.tio.utils.cache.redis.TioRedisCache;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.redisson.api.RTopic;

public class GuavaRedisCache
extends AbsCache {
    public static final String CACHE_CHANGE_TOPIC = "TIO_CACHE_CHANGE_TOPIC_GUAVA";
    private RTopic topic;
    GuavaCache guavaCache;
    TioRedisCache redisCache;

    public GuavaRedisCache(String cacheName, GuavaCache guavaCache, TioRedisCache redisCache) {
        super(cacheName);
        this.guavaCache = guavaCache;
        this.redisCache = redisCache;
    }

    public void clear() {
        this.guavaCache.clear();
        this.redisCache.clear();
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, CacheChangeType.CLEAR);
        this.topic.publish((Object)cacheChangedVo);
    }

    @Override
    public Serializable _get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        Serializable ret = this.guavaCache.get(key);
        if (ret == null) {
            ret = this.redisCache.get(key);
            if (ret != null) {
                this.guavaCache.put(key, ret);
            }
        } else {
            Long timeToIdleSeconds = this.redisCache.getTimeToIdleSeconds();
            if (timeToIdleSeconds != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, timeToIdleSeconds);
            }
        }
        return ret;
    }

    public Iterable<String> keys() {
        return this.redisCache.keys();
    }

    public Collection<String> keysCollection() {
        return this.redisCache.keysCollection();
    }

    public void put(String key, Serializable value) {
        this.guavaCache.put(key, value);
        this.redisCache.put(key, value);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.PUT);
        this.topic.publish((Object)cacheChangedVo);
    }

    public void putTemporary(String key, Serializable value) {
        this.guavaCache.putTemporary(key, value);
        this.redisCache.putTemporary(key, value);
    }

    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.guavaCache.remove(key);
        this.redisCache.remove(key);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.REMOVE);
        this.topic.publish((Object)cacheChangedVo);
    }

    public long ttl(String key) {
        return this.redisCache.ttl(key);
    }

    public Map<String, Serializable> asMap() {
        return this.redisCache.asMap();
    }

    public long size() {
        return this.redisCache.size();
    }

    public void setTopic(Object object) {
    }
}

