/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.guava;

import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.guava.GuavaCache;
import com.litongjava.tio.utils.guava.GuavaUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GuavaCacheFactory implements CacheFactory
{
    INSTANCE;

    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, GuavaCache> map = new HashMap<String, GuavaCache>();
    private Object lock = new Object();

    @Override
    public GuavaCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        return this.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, (RemovalListenerWrapper)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> GuavaCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        GuavaCache guavaCache;
        RemovalListener removalListener = null;
        if (removalListenerWrapper.getListener() instanceof RemovalListener) {
            removalListener = (RemovalListener)removalListenerWrapper.getListener();
        }
        if ((guavaCache = this.map.get(cacheName)) == null) {
            Object object = this.lock;
            synchronized (object) {
                guavaCache = this.map.get(cacheName);
                if (guavaCache == null) {
                    Integer concurrencyLevel = 8;
                    Integer initialCapacity = 10;
                    Integer maximumSize = 5000000;
                    boolean recordStats = false;
                    Integer temporaryMaximumSize = 500000;
                    LoadingCache loadingCache = GuavaUtils.createLoadingCache(concurrencyLevel, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, removalListener);
                    LoadingCache temporaryLoadingCache = GuavaUtils.createLoadingCache(concurrencyLevel, 10L, null, initialCapacity, temporaryMaximumSize, recordStats, removalListener);
                    guavaCache = new GuavaCache(cacheName, loadingCache, temporaryLoadingCache);
                    guavaCache.setTimeToIdleSeconds(timeToIdleSeconds);
                    guavaCache.setTimeToLiveSeconds(timeToLiveSeconds);
                    this.map.put(cacheName, guavaCache);
                }
            }
        }
        return guavaCache;
    }

    @Override
    public GuavaCache getCache(String cacheName, boolean skipNull) {
        GuavaCache guavaCache = this.map.get(cacheName);
        if (guavaCache == null) {
            this.log.error("cacheName[{}] is not yet registered, please register first.", (Object)cacheName);
        }
        return guavaCache;
    }

    @Override
    public GuavaCache getCache(String cacheName) {
        return this.map.get(cacheName);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public GuavaCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds(), (RemovalListenerWrapper)null);
    }
}

