/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.caffeineredis;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheChangeType;
import com.litongjava.tio.utils.cache.CacheChangedVo;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.caffeine.CaffeineCache;
import com.litongjava.tio.utils.cache.caffeine.CaffeineCacheFactory;
import com.litongjava.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import com.litongjava.tio.utils.cache.redis.RedisCacheFactory;
import com.litongjava.tio.utils.cache.redis.TioRedisCache;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CaffeineRedisCacheFactory implements CacheFactory
{
    INSTANCE;

    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Object lock = new Object();
    private Map<String, CaffeineRedisCache> map = new HashMap<String, CaffeineRedisCache>();
    private boolean inited = false;
    private RedissonClient redisson;
    private RTopic topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(RedissonClient redisson) {
        if (!this.inited) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.inited) {
                    this.redisson = redisson;
                    this.topic = redisson.getTopic("TIO_CACHE_CHANGE_TOPIC_CAFFEINE");
                    this.addListener(this.topic);
                    this.inited = true;
                }
            }
        }
    }

    private void addListener(RTopic topic) {
        topic.addListener(CacheChangedVo.class, (MessageListener)new MessageListener<CacheChangedVo>(){

            public void onMessage(CharSequence channel, CacheChangedVo cacheChangedVo) {
                String clientid = cacheChangedVo.getClientId();
                if (StrUtil.isBlank(clientid)) {
                    CaffeineRedisCacheFactory.this.log.error("clientid is null");
                    return;
                }
                if (Objects.equals(CacheChangedVo.CLIENTID, clientid)) {
                    CaffeineRedisCacheFactory.this.log.debug("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f,{}", (Object)clientid);
                    return;
                }
                String cacheName = cacheChangedVo.getCacheName();
                CaffeineRedisCache caffeineRedisCache = CaffeineRedisCacheFactory.this.getCache(cacheName);
                if (caffeineRedisCache == null) {
                    CaffeineRedisCacheFactory.this.log.info("\u4e0d\u80fd\u6839\u636ecacheName[{}]\u627e\u5230CaffeineRedisCache\u5bf9\u8c61", (Object)cacheName);
                    return;
                }
                CacheChangeType type = cacheChangedVo.getType();
                if (type == CacheChangeType.PUT || type == CacheChangeType.UPDATE || type == CacheChangeType.REMOVE) {
                    String key = cacheChangedVo.getKey();
                    caffeineRedisCache.localCache.remove(key);
                } else if (type == CacheChangeType.CLEAR) {
                    caffeineRedisCache.localCache.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CaffeineRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        this.init(this.redisson);
        CaffeineRedisCache caffeineRedisCache = this.map.get(cacheName);
        if (caffeineRedisCache != null) return caffeineRedisCache;
        Class<CaffeineRedisCache> clazz = CaffeineRedisCache.class;
        synchronized (CaffeineRedisCache.class) {
            caffeineRedisCache = this.map.get(cacheName);
            if (caffeineRedisCache != null) return caffeineRedisCache;
            RedisCacheFactory.INSTANCE.setRedisson(this.redisson);
            TioRedisCache redisCache = RedisCacheFactory.INSTANCE.register(cacheName, timeToLiveSeconds, timeToIdleSeconds);
            Long timeToLiveSecondsForCaffeine = timeToLiveSeconds;
            Long timeToIdleSecondsForCaffeine = timeToIdleSeconds;
            if (timeToLiveSecondsForCaffeine != null) {
                timeToLiveSecondsForCaffeine = Math.min(timeToLiveSecondsForCaffeine, 600L);
            }
            if (timeToIdleSecondsForCaffeine != null) {
                timeToIdleSecondsForCaffeine = Math.min(timeToIdleSecondsForCaffeine, 600L);
            }
            CaffeineCache caffeineCache = CaffeineCacheFactory.INSTANCE.register(cacheName, timeToLiveSecondsForCaffeine, timeToIdleSecondsForCaffeine);
            caffeineRedisCache = new CaffeineRedisCache(cacheName, caffeineCache, redisCache);
            caffeineRedisCache.setTopic(this.topic);
            caffeineRedisCache.setTimeToIdleSeconds(timeToIdleSeconds);
            caffeineRedisCache.setTimeToLiveSeconds(timeToLiveSeconds);
            this.map.put(cacheName, caffeineRedisCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return caffeineRedisCache;
        }
    }

    @Override
    public <T> CaffeineRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        return null;
    }

    @Override
    public CaffeineRedisCache getCache(String cacheName, boolean skipNull) {
        CaffeineRedisCache caffeineRedisCache = this.map.get(cacheName);
        if (caffeineRedisCache == null && !skipNull) {
            this.log.error("cacheName[{}] is not yet registered, please register first.", (Object)cacheName);
        }
        return caffeineRedisCache;
    }

    @Override
    public CaffeineRedisCache getCache(String cacheName) {
        return this.getCache(cacheName, false);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public CaffeineRedisCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds());
    }
}

