/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.caffeineredis;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheChangeType;
import com.litongjava.tio.utils.cache.CacheChangedVo;
import com.litongjava.tio.utils.cache.caffeine.CaffeineCache;
import com.litongjava.tio.utils.cache.redis.RedisExpireUpdateTask;
import com.litongjava.tio.utils.cache.redis.TioRedisCache;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.LockUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineRedisCache
extends AbsCache {
    public static final String CACHE_CHANGE_TOPIC = "TIO_CACHE_CHANGE_TOPIC_CAFFEINE";
    private Logger log = LoggerFactory.getLogger(CaffeineRedisCache.class);
    CaffeineCache localCache = null;
    TioRedisCache distCache = null;
    private RTopic topic;

    public CaffeineRedisCache(String cacheName, CaffeineCache caffeineCache, TioRedisCache redisCache) {
        super(cacheName);
        this.localCache = caffeineCache;
        this.distCache = redisCache;
    }

    public void clear() {
        this.localCache.clear();
        this.distCache.clear();
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, CacheChangeType.CLEAR);
        this.topic.publish((Object)cacheChangedVo);
    }

    @Override
    public Serializable _get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        Serializable ret = this.localCache.get(key);
        if (ret == null) {
            try {
                LockUtils.runWriteOrWaitRead("_tio_cr_" + key, this, () -> {
                    Serializable ret1;
                    if (this.localCache.get(key) == null && (ret1 = this.distCache.get(key)) != null) {
                        this.localCache.put(key, ret1);
                    }
                });
            }
            catch (Exception e) {
                this.log.error(e.toString(), (Throwable)e);
            }
            ret = this.localCache.get(key);
        } else {
            Long timeToIdleSeconds = this.distCache.getTimeToIdleSeconds();
            if (timeToIdleSeconds != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, timeToIdleSeconds);
            }
        }
        return ret;
    }

    public Iterable<String> keys() {
        return this.distCache.keys();
    }

    public Collection<String> keysCollection() {
        return this.distCache.keysCollection();
    }

    public void put(String key, Serializable value) {
        this.localCache.put(key, value);
        this.distCache.put(key, value);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.PUT);
        this.topic.publish((Object)cacheChangedVo);
    }

    public void putTemporary(String key, Serializable value) {
        this.localCache.putTemporary(key, value);
        this.distCache.putTemporary(key, value);
    }

    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.localCache.remove(key);
        this.distCache.remove(key);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.REMOVE);
        this.topic.publish((Object)cacheChangedVo);
    }

    public long ttl(String key) {
        return this.distCache.ttl(key);
    }

    public RTopic getTopic() {
        return this.topic;
    }

    public void setTopic(RTopic topic) {
        this.topic = topic;
    }

    public Map<String, Serializable> asMap() {
        return this.distCache.asMap();
    }

    public long size() {
        return this.distCache.size();
    }
}

