/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.caffeine;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.caffeine.CaffeineCache;
import com.litongjava.tio.utils.caffeine.CaffeineUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CaffeineCacheFactory implements CacheFactory
{
    INSTANCE;

    private Logger log = LoggerFactory.getLogger(CaffeineCacheFactory.class);
    private Map<String, CaffeineCache> map = new HashMap<String, CaffeineCache>();
    private Object lock = new Object();

    @Override
    public CaffeineCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        return this.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, (RemovalListenerWrapper)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CaffeineCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        CaffeineCache caffeineCache;
        RemovalListener removalListener = null;
        if (removalListenerWrapper != null && removalListenerWrapper.getListener() instanceof RemovalListener) {
            removalListener = (RemovalListener)removalListenerWrapper.getListener();
        }
        if ((caffeineCache = this.map.get(cacheName)) == null) {
            Object object = this.lock;
            synchronized (object) {
                caffeineCache = this.map.get(cacheName);
                if (caffeineCache == null) {
                    Integer initialCapacity = 10;
                    Integer maximumSize = 5000000;
                    boolean recordStats = false;
                    LoadingCache loadingCache = CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, removalListener);
                    Integer temporaryMaximumSize = 500000;
                    LoadingCache temporaryLoadingCache = CaffeineUtils.createLoadingCache(cacheName, 10L, null, initialCapacity, temporaryMaximumSize, recordStats, removalListener);
                    caffeineCache = new CaffeineCache(cacheName, loadingCache, temporaryLoadingCache);
                    caffeineCache.setTimeToIdleSeconds(timeToIdleSeconds);
                    caffeineCache.setTimeToLiveSeconds(timeToLiveSeconds);
                    this.map.put(cacheName, caffeineCache);
                }
            }
        }
        return caffeineCache;
    }

    @Override
    public CaffeineCache getCache(String cacheName, boolean skipNull) {
        CaffeineCache caffeineCache = this.map.get(cacheName);
        if (caffeineCache == null && !skipNull) {
            this.log.error("cacheName[{}] is not yet registered, please register first.", (Object)cacheName);
        }
        return caffeineCache;
    }

    @Override
    public CaffeineCache getCache(String cacheName) {
        return this.getCache(cacheName, false);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public CaffeineCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds(), (RemovalListenerWrapper)null);
    }
}

