/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.caffeine;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public class CaffeineCache
extends AbsCache {
    private LoadingCache<String, Serializable> loadingCache = null;
    private LoadingCache<String, Serializable> temporaryLoadingCache = null;

    public CaffeineCache(String cacheName, LoadingCache<String, Serializable> loadingCache, LoadingCache<String, Serializable> temporaryLoadingCache) {
        super(cacheName);
        this.loadingCache = loadingCache;
        this.temporaryLoadingCache = temporaryLoadingCache;
    }

    public void clear() {
        this.loadingCache.invalidateAll();
        this.temporaryLoadingCache.invalidateAll();
    }

    @Override
    public Serializable _get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        Serializable ret = (Serializable)this.loadingCache.getIfPresent((Object)key);
        if (ret == null) {
            ret = (Serializable)this.temporaryLoadingCache.getIfPresent((Object)key);
        }
        return ret;
    }

    public Collection<String> keys() {
        ConcurrentMap map = this.loadingCache.asMap();
        return map.keySet();
    }

    public Collection<String> keysCollection() {
        return this.loadingCache.asMap().keySet();
    }

    public void put(String key, Serializable value) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.loadingCache.put((Object)key, (Object)value);
    }

    public void putTemporary(String key, Serializable value) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.temporaryLoadingCache.put((Object)key, (Object)value);
    }

    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.loadingCache.invalidate((Object)key);
        this.temporaryLoadingCache.invalidate((Object)key);
    }

    public ConcurrentMap<String, Serializable> asMap() {
        return this.loadingCache.asMap();
    }

    public long size() {
        return this.loadingCache.estimatedSize();
    }

    public long ttl(String key) {
        throw new RuntimeException("\u4e0d\u652f\u6301ttl");
    }
}

