/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils;

import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.DefaultReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    public static <T extends PropertiesConfiguration> T initConfig(String filename, String encoding, T t) throws FileNotFoundException {
        return ConfigUtils.initConfig(null, filename, encoding, t);
    }

    public static PropertiesConfiguration initConfig(String filename, String encoding) throws FileNotFoundException {
        return ConfigUtils.initConfig(null, filename, encoding);
    }

    public static PropertiesConfiguration initConfig(String filename1, String filename2, String encoding) throws FileNotFoundException {
        return ConfigUtils.initConfig(filename1, filename2, encoding, ',');
    }

    public static PropertiesConfiguration initConfig(String filename1, String filename2, String encoding, char listDelimiter) throws FileNotFoundException {
        Parameters _parameters = new Parameters();
        PropertiesBuilderParameters parameters = _parameters.properties();
        String filename = filename1;
        ClassLoader cl = ConfigUtils.class.getClassLoader();
        URL url = null;
        if (StrUtil.isNotBlank(filename1)) {
            URL uRL = url = cl != null ? cl.getResource(filename1) : ClassLoader.getSystemResource(filename1);
        }
        if (url == null) {
            URL uRL = url = cl != null ? cl.getResource(filename2) : ClassLoader.getSystemResource(filename2);
            if (url == null) {
                throw new FileNotFoundException(filename1);
            }
            filename = filename2;
        }
        parameters.setFileName(filename);
        parameters.setThrowExceptionOnMissing(false);
        parameters.setEncoding(encoding);
        parameters.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(listDelimiter));
        parameters.setReloadingDetectorFactory((ReloadingDetectorFactory)new DefaultReloadingDetectorFactory());
        parameters.setIncludesAllowed(true);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{parameters});
        try {
            PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
            return config;
        }
        catch (ConfigurationException e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T extends PropertiesConfiguration> T initConfig(String filename1, String filename2, String encoding, T t) throws FileNotFoundException {
        return ConfigUtils.initConfig(filename1, filename2, encoding, ',', t);
    }

    public static <T extends PropertiesConfiguration> T initConfig(String filename1, String filename2, String encoding, char listDelimiter, T t) throws FileNotFoundException {
        PropertiesConfiguration config = ConfigUtils.initConfig(filename1, filename2, encoding, listDelimiter);
        t.append((Configuration)config);
        return t;
    }
}

