/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.util;

import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResource;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.MimeType;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.ClassUtil;
import com.litongjava.tio.utils.hutool.FileUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resps {
    private static final Logger log = LoggerFactory.getLogger(Resps.class);

    public static HttpResponse css(HttpRequest request, String bodyString) {
        String charset = request.getCharset();
        return Resps.css(request, bodyString, charset);
    }

    public static HttpResponse css(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_CSS_CSS, charset));
        return ret;
    }

    public static HttpResponse bytes(HttpRequest request, byte[] bodyBytes, String extension) {
        String contentType = null;
        if (StrUtil.isNotBlank((CharSequence)extension)) {
            MimeType mimeType = MimeType.fromExtension((String)extension);
            contentType = mimeType != null ? mimeType.getType() : "application/octet-stream";
        }
        return Resps.bytesWithContentType(request, bodyBytes, contentType);
    }

    public static HttpResponse bytes(HttpResponse response, Byte byteOne, String extension) {
        String contentType = null;
        if (StrUtil.isNotBlank((CharSequence)extension)) {
            MimeType mimeType = MimeType.fromExtension((String)extension);
            contentType = mimeType != null ? mimeType.getType() : "application/octet-stream";
        }
        return Resps.bytesWithContentType(response, byteOne, contentType);
    }

    public static HttpResponse bytes(HttpResponse response, byte[] bodyBytes, String extension) {
        String contentType = null;
        if (StrUtil.isNotBlank((CharSequence)extension)) {
            MimeType mimeType = MimeType.fromExtension((String)extension);
            contentType = mimeType != null ? mimeType.getType() : "application/octet-stream";
        }
        return Resps.bytesWithContentType(response, bodyBytes, contentType);
    }

    public static HttpResponse file(HttpRequest request, File fileOnServer) throws Exception {
        if (fileOnServer == null || !fileOnServer.exists()) {
            return request.httpConfig.getHttpRequestHandler().resp404(request, request.getRequestLine());
        }
        Date lastModified = new Date(fileOnServer.lastModified());
        HttpResponse ret = Resps.try304(request, lastModified.getTime());
        if (ret != null) {
            return ret;
        }
        byte[] bodyBytes = Files.readAllBytes(fileOnServer.toPath());
        String filename = fileOnServer.getName();
        String extension = FileUtil.extName((String)filename);
        ret = Resps.bytes(request, bodyBytes, extension);
        ret.setLastModified(HeaderValue.from((String)(lastModified.getTime() + "")));
        return ret;
    }

    public static HttpResponse file(HttpRequest request, String path) throws Exception {
        HttpResource httpResource = request.httpConfig.getResource(request, path);
        if (httpResource == null) {
            return null;
        }
        path = httpResource.getPath();
        File file = httpResource.getFile();
        if (file != null) {
            return Resps.file(request, file);
        }
        URL url = httpResource.getUrl();
        if (url != null) {
            byte[] bs = FileUtil.readBytes((URL)url);
            return Resps.bytes(request, bs, FileUtil.extName((String)path));
        }
        return Resps.resp404(request);
    }

    public static HttpResponse resp404(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig) throws Exception {
        String file404 = httpConfig.getPage404();
        HttpResource httpResource = request.httpConfig.getResource(request, file404);
        if (httpResource != null) {
            file404 = httpResource.getPath();
            String charset = request.getCharset();
            HttpResponse ret = Resps.forward(request, file404 + "?tio_initpath=" + URLEncoder.encode(requestLine.getPathAndQuery(), charset));
            return ret;
        }
        HttpResponse ret = Resps.html(request, "404");
        ret.setStatus(HttpResponseStatus.C404);
        return ret;
    }

    public static HttpResponse resp404(HttpResponse response, RequestLine requestLine, HttpConfig httpConfig) throws Exception {
        String file404 = httpConfig.getPage404();
        HttpRequest request = response.getHttpRequest();
        HttpResource httpResource = httpConfig.getResource(request, file404);
        if (httpResource != null) {
            file404 = httpResource.getPath();
            String charset = response.getCharset();
            HttpResponse ret = Resps.forward(request, file404 + "?tio_initpath=" + URLEncoder.encode(requestLine.getPathAndQuery(), charset));
            return ret;
        }
        HttpResponse ret = Resps.html(response, "404");
        ret.setStatus(HttpResponseStatus.C404);
        return ret;
    }

    public static HttpResponse resp404(HttpRequest request) throws Exception {
        return Resps.resp404(request, request.requestLine, request.httpConfig);
    }

    public static HttpResponse resp500(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig, Throwable throwable) throws Exception {
        String file500 = httpConfig.getPage500();
        HttpResource httpResource = request.httpConfig.getResource(request, file500);
        if (httpResource != null) {
            file500 = httpResource.getPath();
            HttpResponse ret = Resps.forward(request, file500 + "?tio_initpath=" + requestLine.getPathAndQuery());
            return ret;
        }
        HttpResponse ret = null;
        if (EnvUtils.getBoolean((String)"http.response.showExceptionDetails", (boolean)false)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            ret = Resps.txt(request, sw.toString());
        } else {
            ret = Resps.html(request, "500");
        }
        ret.setStatus(HttpResponseStatus.C500);
        return ret;
    }

    public static HttpResponse resp500(HttpRequest request, Throwable throwable) throws Exception {
        return Resps.resp500(request, request.requestLine, request.httpConfig, throwable);
    }

    public static HttpResponse bytesWithContentType(HttpRequest request, byte[] bodyBytes, String contentType) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        if (StrUtil.isBlank((String)contentType)) {
            ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.DEFAULT_TYPE);
        } else {
            ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)contentType));
        }
        return ret;
    }

    public static HttpResponse bytesWithContentType(HttpResponse response, byte byteOne, String contentType) {
        response.setBody(byteOne);
        if (StrUtil.isBlank((String)contentType)) {
            response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.DEFAULT_TYPE);
        } else {
            response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)contentType));
        }
        return response;
    }

    public static HttpResponse bytesWithContentType(HttpResponse response, byte[] bodyBytes, String contentType) {
        response.setBody(bodyBytes);
        if (StrUtil.isBlank((String)contentType)) {
            response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.DEFAULT_TYPE);
        } else {
            response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)contentType));
        }
        return response;
    }

    public static HttpResponse bytesWithHeaders(HttpRequest request, byte[] bodyBytes, Map<HeaderName, HeaderValue> headers) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        ret.addHeaders(headers);
        return ret;
    }

    public static HttpResponse html(HttpRequest request, String bodyString) {
        String charset = request.getCharset();
        return Resps.html(request, bodyString, charset);
    }

    public static HttpResponse html(HttpResponse response, String bodyString) {
        String charset = response.getCharset();
        return Resps.html(response, bodyString, charset);
    }

    public static HttpResponse xml(HttpResponse response, String bodyString) {
        String charset = response.getCharset();
        return Resps.xml(response, bodyString, charset);
    }

    public static HttpResponse forward(HttpRequest request, String newPath) throws Exception {
        return request.forward(newPath);
    }

    public static HttpResponse html(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_HTML_HTML, charset));
        return ret;
    }

    public static HttpResponse html(HttpResponse response, String bodyString, String charset) {
        return Resps.string(response, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_HTML_HTML, charset));
    }

    public static HttpResponse xml(HttpResponse response, String bodyString, String charset) {
        return Resps.string(response, bodyString, charset, Resps.getMimeTypeStr(MimeType.APPLICATION_XML_XML, charset));
    }

    public static HttpResponse js(HttpRequest request, String bodyString) {
        String charset = request.getCharset();
        return Resps.js(request, bodyString, charset);
    }

    public static HttpResponse js(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JAVASCRIPT_JS, charset));
        return ret;
    }

    public static HttpResponse json(HttpRequest request, Object body) {
        String charset = request.getCharset();
        return Resps.json(request, body, charset);
    }

    public static HttpResponse json(HttpResponse response, Object body) {
        String charset = response.getCharset();
        return Resps.json(response, body, charset);
    }

    public static HttpResponse json(HttpRequest request, Object body, String charset) {
        HttpResponse ret = null;
        ret = body == null ? Resps.string(request, "", charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)) : (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass()) ? Resps.string(request, body + "", charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)) : Resps.string(request, Json.getJson().toJson(body), charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)));
        return ret;
    }

    public static HttpResponse json(HttpResponse response, Object body, String charset) {
        response = body == null ? Resps.string(response, "", charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)) : (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass()) ? Resps.string(response, body + "", charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)) : Resps.string(response, Json.getJson().toJson(body), charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JSON, charset)));
        return response;
    }

    public static String getMimeTypeStr(MimeType mimeType, String charset) {
        if (charset == null) {
            return mimeType.getType();
        }
        return mimeType.getType() + ";charset=" + charset;
    }

    public static HttpResponse redirect(HttpRequest request, String path) {
        return Resps.redirect(request, path, HttpResponseStatus.C302);
    }

    public static HttpResponse redirectForever(HttpRequest request, String path) {
        return Resps.redirect(request, path, HttpResponseStatus.C301);
    }

    public static HttpResponse redirect(HttpRequest request, String path, HttpResponseStatus status) {
        HttpResponse ret = new HttpResponse(request);
        ret.setStatus(status);
        ret.addHeader(HeaderName.Location, HeaderValue.from((String)path));
        return ret;
    }

    public static HttpResponse redirectWithPage(HttpRequest request, String path) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<script>");
        sb.append("window.location.href='").append(path).append("'");
        sb.append("</script>");
        return Resps.html(request, sb.toString());
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String Content_Type2) {
        String charset = request.getCharset();
        return Resps.string(request, bodyString, charset, Content_Type2);
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String charset, String mimeTypeStr) {
        HttpResponse ret = new HttpResponse(request);
        if (bodyString != null) {
            if (charset == null) {
                ret.setBody(bodyString.getBytes());
            } else {
                try {
                    ret.setBody(bodyString.getBytes(charset));
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)mimeTypeStr));
        return ret;
    }

    public static HttpResponse string(HttpResponse response, String bodyString, String charset, String mimeTypeStr) {
        if (bodyString != null) {
            if (charset == null) {
                response.setBody(bodyString.getBytes());
            } else {
                try {
                    response.setBody(bodyString.getBytes(charset));
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)mimeTypeStr));
        return response;
    }

    public static HttpResponse try304(HttpRequest request, long lastModifiedOnServer) {
        String If_Modified_Since = request.getHeader("if-modified-since");
        if (StrUtil.isNotBlank((CharSequence)If_Modified_Since)) {
            Long If_Modified_Since_Date = null;
            try {
                If_Modified_Since_Date = Long.parseLong(If_Modified_Since);
                if (lastModifiedOnServer <= If_Modified_Since_Date) {
                    HttpResponse ret = new HttpResponse(request);
                    ret.setStatus(HttpResponseStatus.C304);
                    return ret;
                }
            }
            catch (NumberFormatException e) {
                log.warn("{}, {} is not an int\uff0cclient:{}", new Object[]{request.getClientIp(), If_Modified_Since, request.getUserAgent()});
                return null;
            }
        }
        return null;
    }

    public static HttpResponse txt(HttpRequest request, String bodyString) {
        String charset = request.getCharset();
        return Resps.txt(request, bodyString, charset);
    }

    public static HttpResponse txt(HttpResponse response, String bodyString) {
        String charset = response.getCharset();
        return Resps.txt(response, bodyString, charset);
    }

    public static HttpResponse text(HttpResponse response, String bodyString) {
        String charset = response.getCharset();
        return Resps.txt(response, bodyString, charset);
    }

    public static HttpResponse txt(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_TXT, charset));
        return ret;
    }

    public static HttpResponse txt(HttpResponse response, String bodyString, String charset) {
        return Resps.string(response, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_TXT, charset));
    }

    public static HttpResponse fail(HttpResponse response, String string) {
        response.setStatus(HttpResponseStatus.C400);
        response.body(string);
        return response;
    }

    public static HttpResponse error(HttpResponse response, String string) {
        response.setStatus(HttpResponseStatus.C500);
        response.body(string);
        return response;
    }
}

