/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.util;

import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.model.HttpCors;

public class CORSUtils {
    public static void enableCORS(HttpResponse response) {
        CORSUtils.enableCORS(response, new HttpCors());
    }

    public static void enableCORS(HttpResponse response, HttpCors httpCors) {
        String allowOrigin = httpCors.getAllowOrigin();
        String allowCredentials = httpCors.getAllowCredentials();
        String allowHeaders = httpCors.getAllowHeaders();
        String allowMethods = httpCors.getAllowMethods();
        String exposeHeaders = httpCors.getExposeHeaders();
        String requestHeaders = httpCors.getRequestHeaders();
        String requestMethod = httpCors.getRequestMethod();
        String origin = httpCors.getOrigin();
        String maxAge = httpCors.getMaxAge();
        response.addHeader(HeaderName.Access_Control_Allow_Origin, HeaderValue.from((String)allowOrigin));
        response.addHeader(HeaderName.Access_Control_Allow_Methods, HeaderValue.from((String)allowMethods));
        response.addHeader(HeaderName.Access_Control_Allow_Headers, HeaderValue.from((String)allowHeaders));
        response.addHeader(HeaderName.Access_Control_Max_Age, HeaderValue.from((String)maxAge));
        response.addHeader(HeaderName.Access_Control_Allow_Credentials, HeaderValue.from((String)allowCredentials));
        if (exposeHeaders != null && exposeHeaders != "") {
            response.addHeader(HeaderName.from((String)"Access-Control-Expose-Headers"), HeaderValue.from((String)exposeHeaders));
        }
        if (requestHeaders != null && requestHeaders != "") {
            response.addHeader(HeaderName.from((String)"Access-Control-Request-Headers"), HeaderValue.from((String)requestHeaders));
        }
        if (requestMethod != null && requestMethod != "") {
            response.addHeader(HeaderName.from((String)"Access-Control-Request-Method"), HeaderValue.from((String)requestMethod));
        }
        if (origin != null && origin != "") {
            response.addHeader(HeaderName.Origin, HeaderValue.from((String)origin));
        }
        response.addHeader(HeaderName.Vary, HeaderValue.from((String)"Origin"));
        response.addHeader(HeaderName.Vary, HeaderValue.from((String)"Access-Control-Request-Method"));
        response.addHeader(HeaderName.Vary, HeaderValue.from((String)"Access-Control-Request-Headers"));
        response.addHeader(HeaderName.Keep_Alive, HeaderValue.from((String)"timeout=60"));
        response.addHeader(HeaderName.Connection, HeaderValue.from((String)"keep-alive"));
    }
}

