/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.stat.ip.path;

import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.http.server.stat.DefaultStatPathFilter;
import com.litongjava.tio.http.server.stat.StatPathFilter;
import com.litongjava.tio.http.server.stat.ip.path.IpAccessStat;
import com.litongjava.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPathAccessStats {
    private static Logger log = LoggerFactory.getLogger(IpPathAccessStats.class);
    private static final String CACHE_NAME = "TIO_IP_ACCESSPATH";
    private TioConfig tioConfig;
    private String tioConfigId;
    private StatPathFilter statPathFilter;
    public final Map<Long, AbsCache> cacheMap = new HashMap<Long, AbsCache>();
    public final List<Long> durationList = new ArrayList<Long>();
    private final Map<Long, IpPathAccessStatListener> listenerMap = new HashMap<Long, IpPathAccessStatListener>();

    public IpPathAccessStats(StatPathFilter statPathFilter, TioConfig tioConfig, IpPathAccessStatListener ipPathAccessStatListener, Long[] durations, RemovalListenerWrapper<?> removalListenerWrapper) {
        this.statPathFilter = statPathFilter;
        if (this.statPathFilter == null) {
            this.statPathFilter = DefaultStatPathFilter.me;
        }
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener, removalListenerWrapper);
            }
        }
    }

    public void addDuration(Long duration, IpPathAccessStatListener ipPathAccessStatListener, RemovalListenerWrapper<?> removalListenerWrapper) {
        CacheFactory cacheFactory = this.tioConfig.getCacheFactory();
        AbsCache absCache = cacheFactory.register(this.getCacheName(duration), duration, null, removalListenerWrapper);
        this.cacheMap.put(duration, absCache);
        this.durationList.add(duration);
        if (ipPathAccessStatListener != null) {
            this.listenerMap.put(duration, ipPathAccessStatListener);
        }
    }

    public IpPathAccessStatListener getListener(Long duration) {
        return this.listenerMap.get(duration);
    }

    public void addDurations(Long[] durations, IpPathAccessStatListener ipPathAccessStatListener, RemovalListenerWrapper<?> removalListenerWrapper) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener, removalListenerWrapper);
            }
        }
    }

    public void removeMonitor(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_ACCESSPATH_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpAccessStat get(Long duration, String ip, boolean forceCreate) {
        if (StrUtil.isBlank((String)ip)) {
            return null;
        }
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        IpAccessStat ipAccessStat = (IpAccessStat)caffeineCache.get(ip);
        if (ipAccessStat == null && forceCreate) {
            AbsCache absCache = caffeineCache;
            synchronized (absCache) {
                ipAccessStat = (IpAccessStat)caffeineCache.get(ip);
                if (ipAccessStat == null) {
                    ipAccessStat = new IpAccessStat(duration, ip);
                    caffeineCache.put(ip, (Serializable)ipAccessStat);
                }
            }
        }
        return ipAccessStat;
    }

    public IpAccessStat get(Long duration, String ip) {
        return this.get(duration, ip, true);
    }

    public Map<String, Serializable> map(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Map map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }

    public StatPathFilter getStatPathFilter() {
        return this.statPathFilter;
    }

    public void setStatPathFilter(StatPathFilter statPathFilter) {
        this.statPathFilter = statPathFilter;
    }
}

